#region License
/* 
 * Copyright (C) 1999-2023 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using System;
using System.Collections.Generic;
using System.Text;

namespace Reko.Arch.M68k
{
    public enum Mnemonic : short
    {
        illegal,

        abcd,
        add,
        adda,
        addi,
        addq,
        addx,
        and,
        andi,
        asl,
        asr,

        bcc,
        bchg,
        bclr,
        bcs,
        beq,
        bf,
        bge,
        bgt,
        bhi,
        bkpt,
        ble,
        bls,
        blt,
        bmi,
        bne,
        bpl,
        bra,
        bset,
        bsr,
        bt,
        btst,
        bvc,
        bvs,

        bfchg,
        bfclr,
        bfexts,
        bfffo,
        bfins,
        bftst,
        callm,
        cas,
        cas2,
        chk,
        chk2,
        cinv,
        cinvl,
        cinvp,
        cinva,
        clr,
        cmp,
        cmp2,
        cmpa,
        cmpi,
        cmpm,

        dbt,
        dbf,
        dbhi,
        dbls,
        dbcc,
        dbcs,
        dbne,
        dbeq,
        dbra,
        dbvc,
        dbvs,
        dbpl,
        dbmi,
        dbge,
        dblt,
        dbgt,
        dble,
        divs,
        divsl,
        divu,
        divul,

        eor,
        eori,
        exg,
        ext,
        extb,

        fmove,
        fmovem,
        fint,
        fsinh,
        fintrz,
        fsqrt,
        flognp1,
        fetoxm1,
        ftanh1,
        fatan,
        fasin,
        fatanh,
        fsin,
        ftan,
        fetox,
        ftwotox,
        ftentox,
        flogn,
        flog10,
        flog2,
        fabs,
        fcosh,
        fneg,
        facos,
        fcos,
        fgetexp,
        fgetman,
        fdiv,
        fmod,
        fadd,
        fmul,
        fmovecr,
        fsgldiv,
        frem,
        fscale,
        fsglmul,
        fsub,
        fsincos,
        fcmp,
        ftst,
        fssqrt,
        fdsqrt,
        fsabs,
        fsneg,
        fdabs,
        fdneg,
        fsdiv,
        fsadd,
        fsmul,
        fddiv,
        fdadd,
        fdmul,
        fssub,
        fdsub,
        frestore,
        fsave,

        fbf,
        fbeq,
        fbogt,
        fboge,
        fbolt,
        fbole,
        fbogl,
        fbor,    
        fbun,
        fbueq,
        fbugt,
        fbuge,
        fbult,
        fbule,
        fbne,
        fbt,    
        fbsf,
        fbseq,
        fbgt,
        fbge,
        fblt,
        fble,
        fbgl,
        fbgle,      
        fbngle,
        fbngl,
        fbnle,
        fbnlt,
        fbnge,
        fbngt,
        fbsne,
        fbst,  

        jmp,
        jsr,
        lea,
        link,
        lsl,
        lsr,
        
        move,
        move16,
        movea,
        movec,
        movem,
        movep,
        moveq,
        moves,
        muls,
        mulu,
        
        nbcd,
        neg,
        negx,
        nop,
        not,
        
        or,
        ori,
        
        pack,

        pbas,
        pbac,
        pbbs,
        pbbc,
        pbcc,
        pbcs,
        pbgs,
        pbgc,
        pbis,
        pbic,
        pbls,
        pblc,
        pbss,
        pbsc,
        pbws,
        pbwc,

        pdbas,
        pdbac,
        pdbbs,
        pdbbc,
        pdbcc,
        pdbcs,
        pdbgs,
        pdbgc,
        pdbis,
        pdbic,
        pdbls,
        pdblc,
        pdbss,
        pdbsc,
        pdbws,
        pdbwc,

        pea,
        pflushr,
        pload,
        pmove,
        pmovefd,
        ptest,
        pvalid,

        reset,
        rol,
        ror,
        roxl,
        roxr,
        rtd,
        rte,
        rtm,
        rtr,
        rts,

        sbcd,
        sub,
        suba,
        subi,
        subq,
        subx,
        st,
        sf,
        shi,
        sls,
        scc,
        scs,
        sne,
        seq,
        svc,
        svs,
        spl,
        smi,
        sge,
        slt,
        sgt,
        sle,
        stop,
        swap,

        tas,
        trap,
        trapt,
        trapf,
        traphi,
        trapls,
        trapcc,
        trapcs,
        trapne,
        trapeq,
        trapvc,
        trapvs,
        trappl,
        trapmi,
        trapge,
        traplt,
        trapgt,
        traple,
        trapv,
        tst,

        unlk,
        unpk,
    }
}
