#region License
/* 
 * Copyright (C) 1999-2023 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using System;
using System.Collections.Generic;
using System.Text;

namespace Reko.Arch.PowerPC
{
    public enum Mnemonic : ushort
    {
        illegal,
        nyi,

        add,
        addc,
        addco,
        adde,
        addeo,
        addo,
        addi,
        addic,
        addis,
        addme,
        addmeo,
        addpcis,
        addze,
        addzeo,
        and,
        andc,
        andi,
        andis,
        b,
        bc,
        bcctr,
        bcctrl,
        bcdadd,
        bcdcfn,
        bcdcfsq,
        bcdcfz,
        bcdcpsgn,
        bcdctn,
        bcdctsq,
        bcdctz,
        bcds,
        bcdsetsgn,
        bcdsr,
        bcdsub,
        bcdtrunc,
        bcdus,
        bcdutrunc,
        bcl,
        bclr,
        bclrl,
        bctar,
        bctarl,
        bctrl,
        bdnz,
        bdnzf,
        bdnzfl,
        bdnzl,
        bdnzt,
        bdnztl,
        bdz,
        bdzf,
        bdzfl,
        bdzl,
        bdzt,
        bdztl,
        beq,
        beql,
        beqlr,
        beqlrl,
        bge,
        bgel,
        bgelr,
        bgelrl,
        bgt,
        bgtl,
        bgtlr,
        bgtlrl,
        bl,
        ble,
        blel,
        blelr,
        blelrl,
        blr,
        blrl,
        blt,
        bltl,
        bltlr,
        bltlrl,
        bne,
        bnel,
        bnelr,
        bnelrl,
        bns,
        bnsl,
        bnslr,
        bnslrl,
        bso,
        bsol,
        bsolr,
        bsolrl,
        cbcdtd,
        clrbhrb,
        cmp,
        cmpi,
        cmpl,
        cmpli,
        cmplw,
        cmplwi,
        cmpwi,
        cntlzd,
        cntlzw,
        cnttzd,
        cnttzw,
        copy,
        crand,
        crandc,
        creqv,
        crnand,
        crnor,
        cror,
        crorc,
        crxor,
        dadd,
        daddq,
        darn,
        dcbf,
        dcbi,
        dcbst,
        dcbt,
        dcbtst,
        dcbz,
        dcffixq,
        dcmpoq,
        dcmpu,
        dctfix,
        dctfixq,
        dctqpq,
        denbcd,
        divd,
        divde,
        divdeu,
        divdu,
        divw,
        divwe,
        divweu,
        divwu,
        dmulq,
        dquaiq,
        dquaq,
        drintn,
        drintnq,
        drintxq,
        drrndq,
        dscri,
        dscriq,
        dsub,
        dsubq,
        dtstdgq,
        dtstexq,
        dtstsfiq,
        dxexq,
        eieio,
        eqv,
        evmhesmfaaw,
        evmhessfaaw,
        extsb,
        extsh,
        extsw,
        extswsli,
        fabs,
        fadd,
        fadds,
        fcfid,
        fcmpo,
        fcmpu,
        fcfidu,
        fctid,
        fctidu,
        fctidz,
        fctiw,
        fctiwuz,
        fctiwz,
        fdiv,
        fdivs,
        fmadd,
        fmadds,
        fmr,
        fmrgew,
        fmsub,
        fmsubs,
        fmul,
        fmuls,
        fnabs,
        fneg,
        fnmadd,
        fnmadds,
        fnmsub,
        fnmsubs,
        fre,
        fres,
        frim,
        frin,
        frip,
        friz,
        frsp,
        frsqrte,
        frsqrtes,
        fsel,
        fsqrt,
        fsqrts,
        fsub,
        fsubs,
        ftdiv,
        ftsqrt,
        hrfid,
        icbi,
        icbt,
        isel,
        isync,
        lbz,
        lbzcix,
        lbzu,
        lbzux,
        lbzx,
        ld,
        ldat,
        ldarx,
        ldcix,
        ldmx,
        ldu,
        ldux,
        ldx,
        lfd,
        lfdp,
        lfdu,
        lfdux,
        lfdx,
        lfs,
        lfsu,
        lfsux,
        lfsx,
        lha,
        lhau,
        lhaux,
        lhax,
        lhbrx,
        lhz,
        lhzu,
        lhzux,
        lhzx,
        lmw,
        lq,
        lswi,
        lswx,
        lvebx,
        lvehx,
        lvewx,
        lvlx,
        lvxl,
        lvsl,
        lvsr,
        lvx,
        lwa,
        lwarx,
        lwax,
        lwbrx,
        lwz,
        lwzu,
        lwzux,
        lwzx,
        lxsihzx,
        lxsiwzx,
        lxv,
        lxvb16x,
        lxvd2x,
        lxvll,
        maddhd,
        maddhdu,
        maddld,
        mcrf,
        mcrfs,
        mfbhrbe,
        mfcr,
        mfctr,
        mffs,
        mflr,
        mfmsr,
        mfocrf,
        mfspr,
        mftb,
        mfvscr,
        mfvsrld,
        modsd,
        modud,
        modsw,
        moduw,
        msgclr,
        msgclrp,
        msgsnd,
        mtcrf,
        mtctr,
        mtfsb0,
        mtfsb1,
        mtfsf,
        mtfsfi,
        mtlr,
        mtmsr,
        mtmsrd,
        mtocrf,
        mtspr,
        mtvscr,
        mtvsrdd,
        mtvsrwa,
        mtvsrws,
        mulhd,
        mulhdu,
        mulhhwu,
        mulhw,
        mulhwu,
        mulld,
        mulli,
        mullw,
        nand,
        neg,
        nego,
        nop,
        nor,
        or,
        orc,
        ori,
        oris,
        popcntb,
        popcntd,
        popcntw,
        prtyd,
        prtyw,
        psq_st,
        rfebb,
        rfi,
        rfid,
        rfscv,
        rldcl,
        rldcr,
        rldic,
        rldicl,
        rldicr,
        rldimi,
        rlwimi,
        rlwinm,
        rlwnm,
        sc,
        setb,
        slbie,
        slbieg,
        slbmfee,
        slbmte,
        slbsync,
        sld,
        slw,
        srad,
        sradi,
        sraw,
        srawi,
        srd,
        srw,
        stb,
        stbcix,
        stbcx,
        stbu,
        stbux,
        stbx,
        std,
        stdat,
        stdbrx,
        stdcx,
        stdcix,
        stdu,
        stdx,
        stfd,
        stfdp,
        stfdu,
        stfdux,
        stfdx,
        stfiwx,
        stfs,
        stfsu,
        stfsux,
        stfsx,
        sth,
        sthbrx,
        sthcix,
        sthcx,
        sthu,
        sthx,
        stmw,
        stop,
        stq,
        stqcx,
        stqdx,
        stswi,
        stswx,
        stvebx,
        stvehx,
        stvewx,
        stvx,
        stvxl,
        stw,
        stwat,
        stwbrx,
        stwcix,
        stwcx,
        stwu,
        stwux,
        stwx,
        stxsd,
        stxsdx,
        stxsihx,
        stxsiwx,
        stxsix,
        stxssp,
        stxv,
        stxvb16x,
        stxvd2x,
        stxvh8x,
        stxvw4x,
        subf,
        subfc,
        subfco,
        subfe,
        subfeo,
        subfic,
        subfme,
        subfmeo,
        subfo,
        subfze,
        subfzeo,
        sync,
        tabort,
        tabortdc,
        tbegin,
        td,
        tdi,
        tlbie,
        tlbiel,
        tlbsync,
        trechkpt,
        treclaim,
        tsr,
        tw,
        twi,
        vabsdub,
        vabsduh,
        vabsduw,
        vaddcuq,
        vaddcuw,
        vaddecuq,
        vaddeuqm,
        vaddfp,
        vaddsbs,
        vaddshs,
        vaddsws,
        vaddubm,
        vaddubs,
        vaddudm,
        vadduhm,
        vadduhs,
        vadduqm,
        vadduwm,
        vadduws,
        vand,
        vandc,
        vavgsb,
        vavgsh,
        vavgsw,
        vavgub,
        vavguh,
        vavguw,
        vbpermd,
        vbpermq,
        vcfsx,
        vcfux,
        vcipher,
        vcipherlast,
        vclzb,
        vclzd,
        vclzh,
        vclzlsbb,
        vclzw,
        vcmpbfp,
        vcmpeqfp,
        vcmpequb,
        vcmpequd,
        vcmpequh,
        vcmpequw,
        vcmpgefp,
        vcmpgtfp,
        vcmpgtsb,
        vcmpgtsd,
        vcmpgtsh,
        vcmpgtsw,
        vcmpgtub,
        vcmpgtud,
        vcmpgtuh,
        vcmpgtuw,
        vcmpneb,
        vcmpneh,
        vcmpnew,
        vcmpnezb,
        vcmpnezh,
        vcmpnezw,
        vctsxs,
        vctuxs,
        vctzb,
        vctzd,
        vctzh,
        vctzlsbb,
        vctzw,
        veqv,
        vexptefp,
        vextractd,
        vextractub,
        vextractuh,
        vextractuw,
        vextsb2d,
        vextsb2w,
        vextsh2d,
        vextsh2w,
        vextsw2d,
        vextublx,
        vextubrx,
        vextuhlx,
        vextuhrx,
        vextuwlx,
        vextuwrx,
        vgbbd,
        vinsertb,
        vinsertd,
        vinserth,
        vinsertw,
        vlogefp,
        vmaddfp,
        vmaxfp,
        vmaxsb,
        vmaxsd,
        vmaxsh,
        vmaxsw,
        vmaxub,
        vmaxud,
        vmaxuh,
        vmaxuw,
        vmhaddshs,
        vmhraddshs,
        vminfp,
        vminsb,
        vminsd,
        vminsh,
        vminsw,
        vminub,
        vminud,
        vminuh,
        vminuw,
        vmladduhm,
        vmrgew,
        vmrghb,
        vmrghh,
        vmrghw,
        vmrglb,
        vmrglh,
        vmrglw,
        vmrgow,
        vmsummbm,
        vmsumubm,
        vmsumuhm,
        vmsumuhs,
        vmul10cuq,
        vmul10ecuq,
        vmul10euq,
        vmul10uq,
        vmulesb,
        vmulesh,
        vmulesw,
        vmuleub,
        vmuleuh,
        vmuleuw,
        vmulosb,
        vmulosh,
        vmulosw,
        vmuloub,
        vmulouh,
        vmulouw,
        vmuluwm,
        vnand,
        vncipher,
        vncipherlast,
        vnegd,
        vnegw,
        vnmsubfp,
        vnor,
        vor,
        vorc,
        vperm,
        vpermr,
        vpkpx,
        vpksdss,
        vpksdus,
        vpkshss,
        vpkshus,
        vpkswss,
        vpkswus,
        vpkudum,
        vpkudus,
        vpkuhum,
        vpkuhus,
        vpkuwum,
        vpkuwus,
        vpmsumb,
        vpmsumd,
        vpmsumh,
        vpmsumw,
        vpopcntb,
        vpopcntd,
        vpopcnth,
        vpopcntw,
        vprtybd,
        vprtybq,
        vprtybw,
        vrefp,
        vrfim,
        vrfin,
        vrfip,
        vrfiz,
        vrlb,
        vrld,
        vrldmi,
        vrldnm,
        vrlh,
        vrlw,
        vrlwmi,
        vrlwnm,
        vrsqrtefp,
        vsbox,
        vsel,
        vshasigmad,
        vshasigmaw,
        vsl,
        vslb,
        vsld,
        vsldoi,
        vslh,
        vslo,
        vslv,
        vslw,
        vspltb,
        vsplth,
        vspltisb,
        vspltish,
        vspltisw,
        vspltw,
        vsr,
        vsrab,
        vsrad,
        vsrah,
        vsraw,
        vsrb,
        vsrd,
        vsrh,
        vsro,
        vsrv,
        vsrw,
        vsubcuq,
        vsubcuw,
        vsubecuq,
        vsubeuqm,
        vsubfp,
        vsubsbs,
        vsubshs,
        vsubsws,
        vsububm,
        vsububs,
        vsubudm,
        vsubuhm,
        vsubuhs,
        vsubuqm,
        vsubuwm,
        vsubuws,
        vsum2sws,
        vsum4sbs,
        vsum4shs,
        vsum4ubs,
        vsumsws,
        vupkhpx,
        vupkhsb,
        vupkhsh,
        vupkhsw,
        vupklpx,
        vupklsb,
        vupklsh,
        vupklsw,
        vxor,
        xor,
        xori,
        xoris,
        xsaddsp,
        xscmpexpqp,
        xscmpoqp,
        xscpsgndp,
        xscpsgnqp,
        xsdivqp,
        xsdivqpo,
        xsiexpdp,
        xsmaddasp,
        xsmaddmdp,
        xsmaddmsp,
        xsmaddqp,
        xsmaddqpo,
        xsmaxcdp,
        xsmsubqp,
        xsmsubqpo,
        xsnmsubmdp,
        xsnegdp,
        xsrdpip,
        xsredp,
        xsrqpi,
        xsrqpix,
        xsrqpxp,
        xssubdp,
        xstdivdp,
        xstsqrtdp,
        xststdcqp,
        xvadddp,
        xvcvdpsxws,
        xvmuldp,
        xvsubdp,
        xvsubsp,
        xvdivdp,
        xvtstdcdp,
        xxsel,
        xxsldwi,

        // XBox360 extensions
        lvlx128,
        lvrx128,
        lvx128,
        stvx128,
        stvlx128,
        stvrx128,
        vaddfp128,
        vand128,
        vcfpsxws128,
        vcmpbfp128,
        vcmpeqfp128,
        vcmpequw128,
        vcmpgefp128,
        vcmpgtfp128,
        vcsxwfp128,
        vexptefp128,
        vlogefp128,
        vmaddcfp128,
        vmaxfp128,
        vminfp128,
        vmrghw128,
        vmrglw128,
        vmsub3fp128,
        vmsub4fp128,
        vmulfp128,
        vor128,
        vperm128,
        vpkd3d128,
        vrefp128,
        vrfin128,
        vrfiz128,
        vrlimi128,
        vrsqrtefp128,
        vslb128,
        vsldoi128,
        vslw128,
        vspltisw128,
        vspltw128,
        vsrw128,
        vsubfp128,
        vxor128,
        lvewx128,
        lvlxl128,
        lvrxl128,
        lvsl128,
        lvsr128,
        lvxl128,
        stvewx128,
        stvrxl128,
        stvxl128,
        vandc128,
        vnor128,
        vpkshss128,
        vpkshus128,
        vpkswss128,
        vpkswus128,
        vpkuhum128,
        vpkuhus128,
        vpkuwum128,
        vpkuwus128,
        vmaddfp128,
        vnmsubfp128,
        vupkd3d128,
        vupkhsb128,
        vupklsb128,
        vsel128,
        vslo128,
        vsro128,

        vmsumshm,
        vmsumshs,
        vpermxor,
        ps_neg,
        ps_sub,
        ps_mul,
        ps_muls0,
        ps_muls1,
        ps_madds0,
        ps_madds1,
        ps_sum0,
        ps_sum1,
        ps_div,
        ps_add,
        ps_madd,
        psq_lx,
        psq_lux,
        psq_stx,
        psq_stux,
        ps_rsqrte,
        ps_mr,
        ps_nabs,
        ps_abs,
        ps_res,
        ps_merge00,
        ps_merge01,
        ps_merge10,
        ps_merge11,
        ps_msub,
        ps_nmsub,
        ps_nmadd,
        ps_sel,
        ps_cmpo0,
        psq_l,
        psq_lu,
        psq_stu,
        mffpsrd,
        mfvrd,
        vpermwi128,
        vsraw128,
        vcfpuxws128,
        vcuxwfp128,
        vrfip128,
        vrfim128,
        sthux,
        lfdpx,
        lfiwax,
        lfiwzx,
        stfdpx,
    }
}
