#region License
/* 
 * Copyright (C) 1999-2023 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using Reko.Core.Machine;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Reko.Arch.Vax
{
    using Decoder = Decoder<VaxDisassembler, Mnemonic, VaxInstruction>;

    public partial class VaxDisassembler
    {
        private static Decoder[] twoByteInstructions = new[]
        {
/* 00FD */ Instr(Mnemonic.Reserved, -1),
/* 01FD */ Instr(Mnemonic.Reserved, -1),
/* 02FD */ Instr(Mnemonic.Reserved, -1),
/* 03FD */ Instr(Mnemonic.Reserved, -1),
/* 04FD */ Instr(Mnemonic.Reserved, -1),
/* 05FD */ Instr(Mnemonic.Reserved, -1),
/* 06FD */ Instr(Mnemonic.Reserved, -1),
/* 07FD */ Instr(Mnemonic.Reserved, -1),
/* 08FD */ Instr(Mnemonic.Reserved, -1),
/* 30FD */ Instr(Mnemonic.Reserved, -1),
/* 31FD */ Instr(Mnemonic.mfvp, -1),
/* 32FD */ Instr(Mnemonic.cvtdh, -1),
/* 33FD */ Instr(Mnemonic.cvtgf, -1),
/* 34FD */ Instr(Mnemonic.vldl, -1),
/* 35FD */ Instr(Mnemonic.vgathl, -1),
/* 36FD */ Instr(Mnemonic.vldq, -1),
/* 37FD */ Instr(Mnemonic.vgathq, -1),
/* 38FD */ Instr(Mnemonic.Reserved, -1),
/* 09FD */ Instr(Mnemonic.Reserved, -1),
/* 39FD */ Instr(Mnemonic.Reserved, -1),
/* 0AFD */ Instr(Mnemonic.Reserved, -1),
/* 3AFD */ Instr(Mnemonic.Reserved, -1),
/* 0BFD */ Instr(Mnemonic.Reserved, -1),
/* 3BFD */ Instr(Mnemonic.Reserved, -1),
/* 0CFD */ Instr(Mnemonic.Reserved, -1),
/* 3CFD */ Instr(Mnemonic.Reserved, -1),
/* 0DFD */ Instr(Mnemonic.Reserved, -1),
/* 3DFD */ Instr(Mnemonic.Reserved, -1),
/* 0EFD */ Instr(Mnemonic.Reserved, -1),
/* 3EFD */ Instr(Mnemonic.Reserved, -1),
/* 0FFD */ Instr(Mnemonic.Reserved, -1),
/* 3FFD */ Instr(Mnemonic.Reserved, -1),
/* 10FD */ Instr(Mnemonic.Reserved, -1),
/* 40FD */ Instr(Mnemonic.addg2, -1),
/* 11FD */ Instr(Mnemonic.Reserved, -1),
/* 41FD */ Instr(Mnemonic.addg3, -1),
/* 12FD */ Instr(Mnemonic.Reserved, -1),
/* 42FD */ Instr(Mnemonic.subg2, -1),
/* 13FD */ Instr(Mnemonic.Reserved, -1),
/* 43FD */ Instr(Mnemonic.subg3, -1),
/* 14FD */ Instr(Mnemonic.Reserved, -1),
/* 44FD */ Instr(Mnemonic.mulg2, -1),
/* 15FD */ Instr(Mnemonic.Reserved, -1),
/* 45FD */ Instr(Mnemonic.mulg3, -1),
/* 16FD */ Instr(Mnemonic.Reserved, -1),
/* 46FD */ Instr(Mnemonic.divg2, -1),
/* 17FD */ Instr(Mnemonic.Reserved, -1),
/* 47FD */ Instr(Mnemonic.divg3, -1),
/* 18FD */ Instr(Mnemonic.Reserved, -1),
/* 48FD */ Instr(Mnemonic.cvtgb, -1),
/* 19FD */ Instr(Mnemonic.Reserved, -1),
/* 49FD */ Instr(Mnemonic.cvtgw, -1),
/* 1AFD */ Instr(Mnemonic.Reserved, -1),
/* 4AFD */ Instr(Mnemonic.cvtgl, -1),
/* 1BFD */ Instr(Mnemonic.Reserved, -1),
/* 4BFD */ Instr(Mnemonic.cvtrgl, -1),
/* 1CFD */ Instr(Mnemonic.Reserved, -1),
/* 4CFD */ Instr(Mnemonic.cvtbg, -1),
/* 1DFD */ Instr(Mnemonic.Reserved, -1),
/* 4DFD */ Instr(Mnemonic.cvtwg, -1),
/* 1EFD */ Instr(Mnemonic.Reserved, -1),
/* 4EFD */ Instr(Mnemonic.cvtlg, -1),
/* 1FFD */ Instr(Mnemonic.Reserved, -1),
/* 4FFD */ Instr(Mnemonic.acbg,  rg,rg,mg,bw),
/* 20FD */ Instr(Mnemonic.Reserved, -1),
/* 50FD */ Instr(Mnemonic.movg, -1),
/* 21FD */ Instr(Mnemonic.Reserved, -1),
/* 51FD */ Instr(Mnemonic.cmpg, -1),
/* 22FD */ Instr(Mnemonic.Reserved, -1),
/* 52FD */ Instr(Mnemonic.mnegg, -1),
/* 23FD */ Instr(Mnemonic.Reserved, -1),
/* 53FD */ Instr(Mnemonic.tstg, -1),
/* 24FD */ Instr(Mnemonic.Reserved, -1),
/* 54FD */ Instr(Mnemonic.emodg,  rg,rb,rd,wl,wg),
/* 25FD */ Instr(Mnemonic.Reserved, -1),
/* 55FD */ Instr(Mnemonic.polyg,  rg,rw,ab), 
/* 26FD */ Instr(Mnemonic.Reserved, -1),
/* 56FD */ Instr(Mnemonic.cvtgh, -1),
/* 27FD */ Instr(Mnemonic.Reserved, -1),
/* 57FD */ Instr(Mnemonic.Reserved, -1),
/* 28FD */ Instr(Mnemonic.Reserved, -1),
/* 58FD */ Instr(Mnemonic.Reserved, -1),
/* 29FD */ Instr(Mnemonic.Reserved, -1),
/* 59FD */ Instr(Mnemonic.Reserved, -1),
/* 2AFD */ Instr(Mnemonic.Reserved, -1),
/* 5AFD */ Instr(Mnemonic.Reserved, -1),
/* 2BFD */ Instr(Mnemonic.Reserved, -1),
/* 5BFD */ Instr(Mnemonic.Reserved, -1),
/* 2CFD */ Instr(Mnemonic.Reserved, -1),
/* 5CFD */ Instr(Mnemonic.Reserved, -1),
/* 2DFD */ Instr(Mnemonic.Reserved, -1),
/* 5DFD */ Instr(Mnemonic.Reserved, -1),
/* 2EFD */ Instr(Mnemonic.Reserved, -1),
/* 5EFD */ Instr(Mnemonic.Reserved, -1),
/* 2FFD */ Instr(Mnemonic.Reserved, -1),
/* 5FFD */ Instr(Mnemonic.Reserved, -1),
/* 60FD */ Instr(Mnemonic.addh2, rh,wh),
/* 90FD */ Instr(Mnemonic.Reserved, -1),
/* 61FD */ Instr(Mnemonic.addh3, rh,rh,wh),
/* 91FD */ Instr(Mnemonic.Reserved, -1),
/* 62FD */ Instr(Mnemonic.subh2, rh,wh),
/* 92FD */ Instr(Mnemonic.Reserved, -1),
/* 63FD */ Instr(Mnemonic.subh3, rh,rh,wh),
/* 93FD */ Instr(Mnemonic.Reserved, -1),
/* 64FD */ Instr(Mnemonic.mulh2, rh,wh),
/* 94FD */ Instr(Mnemonic.Reserved, -1),
/* 65FD */ Instr(Mnemonic.mulh3, rh,rh,wh),
/* 95FD */ Instr(Mnemonic.Reserved, -1),
/* 66FD */ Instr(Mnemonic.divh2, rh,wh),
/* 96FD */ Instr(Mnemonic.Reserved, -1),
/* 67FD */ Instr(Mnemonic.divh3, rh,rh,wh),
/* 97FD */ Instr(Mnemonic.Reserved, -1),
/* 68FD */ Instr(Mnemonic.cvthb, -1),
/* 98FD */ Instr(Mnemonic.cvtfh, -1),
/* 69FD */ Instr(Mnemonic.cvthw, -1),
/* 99FD */ Instr(Mnemonic.cvtfg, -1),
/* 6AFD */ Instr(Mnemonic.cvthl, -1),
/* 9AFD */ Instr(Mnemonic.Reserved, -1),
/* 6BFD */ Instr(Mnemonic.cvtrhl, -1),
/* 9BFD */ Instr(Mnemonic.Reserved, -1),
/* 6CFD */ Instr(Mnemonic.cvtbh, -1),
/* 9CFD */ Instr(Mnemonic.vstl, -1),
/* 6DFD */ Instr(Mnemonic.cvtwh, -1),
/* 9DFD */ Instr(Mnemonic.vscatl, -1),
/* 6EFD */ Instr(Mnemonic.cvtlh, -1),
/* 9EFD */ Instr(Mnemonic.vstq, -1),
/* 6FFD */ Instr(Mnemonic.acbh,  rh,rh,mh,bw),
/* 9FFD */ Instr(Mnemonic.vscatq, -1),
/* 70FD */ Instr(Mnemonic.movh, -1),
/* 71FD */ Instr(Mnemonic.cmph, -1),
/* 72FD */ Instr(Mnemonic.mnegh, -1),
/* 73FD */ Instr(Mnemonic.tsth, -1),
/* 74FD */ Instr(Mnemonic.emodh,  rh,rb,rd,wl,wh),
/* 75FD */ Instr(Mnemonic.polyh,  rh,rw,ab), 
/* 76FD */ Instr(Mnemonic.cvthg, -1),
/* 77FD */ Instr(Mnemonic.Reserved, -1),
/* 78FD */ Instr(Mnemonic.Reserved, -1),
/* 79FD */ Instr(Mnemonic.Reserved, -1),
/* 7AFD */ Instr(Mnemonic.Reserved, -1),
/* 7BFD */ Instr(Mnemonic.Reserved, -1),
/* 7CFD */ Instr(Mnemonic.clrh, -1), // clro, -1),
/* 7DFD */ Instr(Mnemonic.movo, -1),
/* 7EFD */ Instr(Mnemonic.movah, -1), //  movao, -1),
/* 7FFD */ Instr(Mnemonic.pushah, -1), // pushao, -1),


/* 80FD */ Instr(Mnemonic.vvaddl, -1),
/* 81FD */ Instr(Mnemonic.vsaddl, -1),
/* 82FD */ Instr(Mnemonic.vvaddg, -1),
/* 83FD */ Instr(Mnemonic.vsaddg, -1),
/* 84FD */ Instr(Mnemonic.vvaddf, -1),
/* 85FD */ Instr(Mnemonic.vsaddf, -1),
/* 86FD */ Instr(Mnemonic.vvaddd, -1),
/* 87FD */ Instr(Mnemonic.vsaddd, -1),
/* 88FD */ Instr(Mnemonic.vvsubl, -1),
/* 89FD */ Instr(Mnemonic.vssubl, -1),
/* 8AFD */ Instr(Mnemonic.vvsubg, -1),
/* 8BFD */ Instr(Mnemonic.vssubg, -1),
/* 8CFD */ Instr(Mnemonic.vvsubf, -1),
/* 8DFD */ Instr(Mnemonic.vssubf, -1),
/* 8EFD */ Instr(Mnemonic.vvsubd, -1),
/* 8FFD */ Instr(Mnemonic.vssubd, -1),

/* A0FD */ Instr(Mnemonic.vvmull, -1),
/* A1FD */ Instr(Mnemonic.vsmull, -1),
/* A2FD */ Instr(Mnemonic.vvmulg, -1),
/* A3FD */ Instr(Mnemonic.vsmulg, -1),
/* A4FD */ Instr(Mnemonic.vvmulf, -1),
/* A5FD */ Instr(Mnemonic.vsmulf, -1),
/* A6FD */ Instr(Mnemonic.vvmuld, -1),
/* A7FD */ Instr(Mnemonic.vsmuld, -1),
/* A8FD */ Instr(Mnemonic.vsync, -1),
/* A9FD */ Instr(Mnemonic.mtvp, -1),
/* AAFD */ Instr(Mnemonic.vvdivg, -1),
/* ABFD */ Instr(Mnemonic.vsdivg, -1),
/* ACFD */ Instr(Mnemonic.vvdivf, -1),
/* ADFD */ Instr(Mnemonic.vsdivf, -1),
/* AEFD */ Instr(Mnemonic.vvdivd, -1),
/* AFFD */ Instr(Mnemonic.vsdivd, -1),

/* B0FD */ Instr(Mnemonic.Reserved, -1),
/* B1FD */ Instr(Mnemonic.Reserved, -1),
/* B2FD */ Instr(Mnemonic.Reserved, -1),
/* B3FD */ Instr(Mnemonic.Reserved, -1),
/* B4FD */ Instr(Mnemonic.Reserved, -1),
/* B5FD */ Instr(Mnemonic.Reserved, -1),
/* B6FD */ Instr(Mnemonic.Reserved, -1),
/* B7FD */ Instr(Mnemonic.Reserved, -1),
/* B8FD */ Instr(Mnemonic.Reserved, -1),
/* B9FD */ Instr(Mnemonic.Reserved, -1),
/* BAFD */ Instr(Mnemonic.Reserved, -1),
/* BBFD */ Instr(Mnemonic.Reserved, -1),
/* BCFD */ Instr(Mnemonic.Reserved, -1),
/* BDFD */ Instr(Mnemonic.Reserved, -1),
/* BEFD */ Instr(Mnemonic.Reserved, -1),
/* BFFD */ Instr(Mnemonic.Reserved, -1),

/* C0FD */ Instr(Mnemonic.vvcmpl, -1),
/* C1FD */ Instr(Mnemonic.vscmpl, -1),
/* C2FD */ Instr(Mnemonic.vvcmpg, -1),
/* C3FD */ Instr(Mnemonic.vscmpg, -1),
/* C4FD */ Instr(Mnemonic.vvcmpf, -1),
/* C5FD */ Instr(Mnemonic.vscmpf, -1),
/* C6FD */ Instr(Mnemonic.vvcmpd, -1),
/* C7FD */ Instr(Mnemonic.vscmpd, -1),
/* C8FD */ Instr(Mnemonic.vvbisl, -1),
/* C9FD */ Instr(Mnemonic.vsbisl, -1),
/* CAFD */ Instr(Mnemonic.Invalid, -1),
/* CBFD */ Instr(Mnemonic.Invalid, -1),
/* CCFD */ Instr(Mnemonic.vvbicl, -1),
/* CDFD */ Instr(Mnemonic.vsbicl, -1),
/* CEFD */ Instr(Mnemonic.Invalid, -1),
/* CFFD */ Instr(Mnemonic.Invalid, -1),

/* D0FD */ Instr(Mnemonic.Reserved, -1),
/* D1FD */ Instr(Mnemonic.Reserved, -1),
/* D2FD */ Instr(Mnemonic.Reserved, -1),
/* D3FD */ Instr(Mnemonic.Reserved, -1),
/* D4FD */ Instr(Mnemonic.Reserved, -1),
/* D5FD */ Instr(Mnemonic.Reserved, -1),
/* D6FD */ Instr(Mnemonic.Reserved, -1),
/* D7FD */ Instr(Mnemonic.Reserved, -1),
/* D8FD */ Instr(Mnemonic.Reserved, -1),
/* D9FD */ Instr(Mnemonic.Reserved, -1),
/* DAFD */ Instr(Mnemonic.Reserved, -1),
/* DBFD */ Instr(Mnemonic.Reserved, -1),
/* DCFD */ Instr(Mnemonic.Reserved, -1),
/* DDFD */ Instr(Mnemonic.Reserved, -1),
/* DEFD */ Instr(Mnemonic.Reserved, -1),
/* DFFD */ Instr(Mnemonic.Reserved, -1),

/* E0FD */ Instr(Mnemonic.vvsrll, -1),
/* E1FD */ Instr(Mnemonic.vssrll, -1),
/* E2FD */ Instr(Mnemonic.Invalid, -1),
/* E3FD */ Instr(Mnemonic.Invalid, -1),
/* E4FD */ Instr(Mnemonic.vvslll, -1),
/* E5FD */ Instr(Mnemonic.vsslll, -1),
/* E6FD */ Instr(Mnemonic.Invalid, -1),
/* E7FD */ Instr(Mnemonic.Invalid, -1),
/* E8FD */ Instr(Mnemonic.vvxorl, -1),
/* E9FD */ Instr(Mnemonic.vsxorl, -1),
/* EAFD */ Instr(Mnemonic.Invalid, -1),
/* EBFD */ Instr(Mnemonic.Invalid, -1),
/* ECFD */ Instr(Mnemonic.vvcvt, -1),
/* EDFD */ Instr(Mnemonic.iota, -1),
/* EEFD */ Instr(Mnemonic.vvmerge, -1),
/* EFFD */ Instr(Mnemonic.vsmerge, -1),

/* F0FD */ Instr(Mnemonic.Reserved, -1),
/* F1FD */ Instr(Mnemonic.Reserved, -1),
/* F2FD */ Instr(Mnemonic.Reserved, -1),
/* F3FD */ Instr(Mnemonic.Reserved, -1),
/* F4FD */ Instr(Mnemonic.Reserved, -1),
/* F5FD */ Instr(Mnemonic.Reserved, -1),
/* F6FD */ Instr(Mnemonic.cvthf, -1),
/* F7FD */ Instr(Mnemonic.cvthd, -1),
/* F8FD */ Instr(Mnemonic.Reserved, -1),
/* F9FD */ Instr(Mnemonic.Reserved, -1),
/* FAFD */ Instr(Mnemonic.Reserved, -1),
/* FBFD */ Instr(Mnemonic.Reserved, -1),
/* FCFD */ Instr(Mnemonic.Reserved, -1),
/* FCFE */ Instr(Mnemonic.Reserved, -1),
/* FCFF */ Instr(Mnemonic.Reserved, -1),

/* FDFF */ Instr(Mnemonic.bugl, -1),
/* FEFF */ Instr(Mnemonic.bugw, -1),
/* FFFF */ Instr(Mnemonic.Reserved   , -1), // invalid opcode, basically

    };
    }
}
