#region License
/* 
 * Copyright (C) 1999-2023 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

namespace Reko.Arch.X86
{
    public enum Mnemonic : ushort
    {
        illegal,

        @in,
        @int,
        @lock,
        @out,
        aaa,
        aad,
        aam,
        aas,
        adc,
        adcx,
        add,
        addpd,
        addps,
        addsd,
        addss,
        addsubpd,
        addsubps,
        adox,
        aesdec,
        aesdeclast,
        aesenc,
        aesenclast,
        aesimc,
        aeskeygen,
        and,
        andn,
        andnpd,
        andnps,
        andpd,
        andps,
        arpl,
        bextr,
        blendpd,
        blendps,
        blendvpd,
        blendvps,
        blsi,
        blsmsk,
        blsr,
        bound,
        bsf,
        bsr,
        bswap,
        bt,
        btc,
        btr,
        bts,
        bzhi,
        call,
        cbw,
        cdq,
        cdqe,
        clac,
        clc,
        cld,
        cldemote,
        clflush,
        cli,
        clts,
        cmc,
        cmova,
        cmovbe,
        cmovc,
        cmovg,
        cmovge,
        cmovl,
        cmovle,
        cmovnc,
        cmovno,
        cmovns,
        cmovnz,
        cmovo,
        cmovpe,
        cmovpo,
        cmovs,
        cmovz,
        cmp,
        cmppd,
            cmpeqpd,
            cmpltpd,
            cmplepd,
            cmpunordpd,
            cmpneqpd,
            cmpnltpd,
            cmpnlepd,
            cmpordpd,
        cmpps,
            cmpeqps,
            cmpltps,
            cmpleps,
            cmpunordps,
            cmpneqps,
            cmpnltps,
            cmpnleps,
            cmpordps,
        cmps,
        cmpsb,
        cmpsd,
            cmpeqsd,
            cmpltsd,
            cmplesd,
            cmpunordsd,
            cmpneqsd,
            cmpnltsd,
            cmpnlesd,
            cmpordsd,
        cmpss,
            cmpeqss,
            cmpltss,
            cmpless,
            cmpunordss,
            cmpneqss,
            cmpnltss,
            cmpnless,
            cmpordss,
        cmpxchg,
        cmpxchg16b,
        cmpxchg8b,
        comisd,
        comiss,
        cpuid,
        cqo,
        crc32,
        cvtdq2pd,
        cvtdq2ps,
        cvtpd2dq,
        cvtpd2ps,
        cvtpd2si,
        cvtph2ps,
        cvtpi2pd,
        cvtpi2ps,
        cvtps2dq,
        cvtps2pd,
        cvtps2pi,
        cvtsd2si,
        cvtsd2ss,
        cvtsi2sd,
        cvtsi2ss,
        cvtss2sd,
        cvtss2si,
        cvttpd2dq,
        cvttpd2pi,
        cvttpd2si,
        cvttps2dq,
        cvttps2pi,
        cvttsd2si,
        cvttss2si,
        cwd,
        cwde,
        daa,
        das,
        dec,
        div,
        divpd,
        divps,
        divsd,
        divss,
        dppd,
        dpps,
        emms,
        endbr32,
        endbr64,
        enter,
        enterw,
        extractps,
        f2xm1,
        fabs,
        fadd,
        faddp,
        fbld,
        fbstp,
        fchs,
        fclex,
        fcmovb,
        fcmovbe,
        fcmove,
        fcmovnb,
        fcmovnbe,
        fcmovne,
        fcmovnu,
        fcmovu,
        fcom,
        fcomi,
        fcomip,
        fcomp,
        fcompp,
        fcos,
        fdecstp,
        fdiv,
        fdivp,
        fdivr,
        fdivrp,
        femms,
        ffree,
        ffreep,
        fiadd,
        ficom,
        ficomp,
        fidiv,
        fidivr,
        fild,
        fildcw,
        fildenv,
        fimul,
        fincstp,
        fist,
        fistcw,
        fistenv,
        fistp,
        fisttp,
        fisub,
        fisubr,
        fld,
        fld1,
        fldcw,
        fldenv,
        fldl2e,
        fldl2t,
        fldlg2,
        fldln2,
        fldpi,
        fldz,
        fmul,
        fmulp,
        fndisi,
        fneni,
        fninit,
        fnop,
        fnsetpm,
        fpatan,
        fprem,
        fprem1,
        fptan,
        frndint,
        frstor,
        frstpm,
        fsave,
        fscale,
        fsin,
        fsincos,
        fsqrt,
        fst,
        fstcw,
        fstenv,
        fstp,
        fstsw,
        fsub,
        fsubp,
        fsubr,
        fsubrp,
        ftst,
        fucom,
        fucomi,
        fucomip,
        fucomp,
        fucompp,
        fxam,
        fxch,
        fxrstor,
        fxsave,
        fxtract,
        fyl2x,
        fyl2xp1,
        getsec,
        haddpd,
        haddps,
        hlt,
        hsubpd,
        hsubps,
        icebp,
        idiv,
        imul,
        inc,
        ins,
        insb,
        inserps,
        into,
        invd,
        invept,
        invlpg,
        invpcid,
        invvpid,
        iret,
        ja,
        jbe,
        jc,
        jcxz,
        jecxz,
        jg,
        jge,
        jknz,
        jkz,
        jl,
        jle,
        jmp,
        jmpe,
        jnc,
        jno,
        jns,
        jnz,
        jo,
        jpe,
        jpo,
        jrcxz,
        js,
        jz,
        kaddw,
        kaddb,
        kaddq,
        kadd,
        kandb,
        kandd,
        kandq,
        kandw,
        kandnb,
        kandnd,
        kandnq,
        kandnw,
        kmovb,
        kmovd,
        kmovq,
        kmovw,
        kunpckwd,
        kunpckbw,
        kunpckdq,
        kxorb,
        kxord,
        kxorq,
        kxorw,
        lahf,
        lar,
        lddqu,
        ldmxcsr,
        lds,
        lea,
        leave,
        les,
        lfence,
        lfs,
        lgdt,
        lgs,
        lidt,
        lldt,
        lmsw,
        lods,
        lodsb,
        loop,
        loope,
        loopne,
        lsl,
        lss,
        ltr,
        lzcnt,
        maskmovdqu,
        maskmovq,
        maxpd,
        maxps,
        maxsd,
        maxss,
        mfence,
        minpd,
        minps,
        minsd,
        minss,
        monitor,
        monitorx,
        mov,
        movapd,
        movaps,
        movbe,
        movd,
        movddup,
        movdqa,
        movdqu,
        movhpd,
        movhps,
        movlhps,
        movlpd,
        movlps,
        movmskpd,
        movmskps,
        movnti,
        movntpd,
        movntps,
        movntq,
        movq,
        movs,
        movsb,
        movsd,
        movshdup,
        movsldup,
        movss,
        movsx,
        movsxd,
        movupd,
        movups,
        movzx,
        mpsadbw,
        mul,
        mulpd,
        mulps,
        mulsd,
        mulss,
        mulx,
        mwait,
        mwaitx,
        neg,
        nop,
        not,
        or,
        orpd,
        orps,
        outs,
        outsb,
        pabsb,
        pabsd,
        pabsw,
        packssdw,
        packsswb,
        packuswb,
        paddb,
        paddd,
        paddq,
        paddsb,
        paddsw,
        paddusb,
        paddusw,
        paddw,
        palignr,
        pand,
        pandn,
        pause,
        pavgb,
        pavgw,
        pblendd,
        pblendvb,
        pblendvdb,
        pblendw,
        pclmulqdq,
        pcmpeqb,
        pcmpeqd,
        pcmpeqw,
        pcmpestri,
        pcmpestrm,
        pcmpgtb,
        pcmpgtd,
        pcmpgtq,
        pcmpgtw,
        pcmpistri,
        pcmpistrm,
        pdep,
        pext,
        pextrb,
        pextrd,
        pextrq,
        pextrw,
        phaddd,
        phaddsw,
        phaddw,
        phsubd,
        phsubsw,
        phsubw,
        pinsrb,
        pinsrd,
        pinsrq,
        pinsrw,
        pmaddubsw,
        pmaddwd,
        pmaxsb  ,
        pmaxsd,
        pmaxsw,
        pmaxub,
        pmaxud,
        pmaxuw,
        pmaxuq,
        pminsb,
        pminsd,
        pminsq,
        pminsw,
        pminub,
        pminud,
        pminuw,
        pmovmskb,
        pmovsxbd,
        pmovsxbq,
        pmovsxbw,
        pmovsxdq,
        pmovsxwd,
        pmovsxwq,
        pmovzxbd,
        pmovzxbq,
        pmovzxbw,
        pmovzxdq,
        pmovzxwd,
        pmuldq,
        pmulhrsw,
        pmulhuw,
        pmulhw,
        pmulld,
        pmullw,
        pmuludq,
        pop,
        popa,
        popcnt,
        popf,
        popfw,
        popw,
        por,
        prefetchnta,
        prefetcht0,
        prefetcht1,
        prefetcht2,
        prefetchw,
        psadbw,
        pshufb,
        pshufd,
        pshufhw,
        pshuflw,
        pshufw,
        psignb,
        psignd,
        psignw,
        pslld,
        pslldq,
        psllq,
        psllw,
        psrad,
        psraw,
        psrld,
        psrldq,
        psrlq,
        psrlw,
        psubb,
        psubd,
        psubq,
        psubsb,
        psubsw,
        psubusb,
        psubusw,
        psubw,
        ptest,
        punpckhbw,
        punpckhdq,
        punpckhqdq,
        punpckhwd,
        punpcklbw,
        punpckldq,
        punpcklqdq,
        punpcklwd,
        push,
        pusha,
        pushf,
        pushw,
        pxor,
        rcl,
        rcpps,
        rcpss,
        rcr,
        rdmsr,
        rdpkru,
        rdpmc,
        rdrand,
        rdseed,
        rdtsc,
        rdtscp,
        ret,
        retf,
        rol,
        ror,
        rorx,
        roundpd,
        roundps,
        roundsd,
        roundss,
        rsm,
        rsqrtps,
        rsqrtss,
        sahf,
        sar,
        sarx,
        sbb,
        scas,
        scasb,
        seta,
        setbe,
        setc,
        setg,
        setge,
        setl,
        setle,
        setnc,
        setno,
        setns,
        setnz,
        seto,
        setpe,
        setpo,
        sets,
        setz,
        sfence,
        sgdt,
        sha1msg1,
        sha1msg2,
        sha1nexte,
        sha1rnds4,
        sha256mds2,
        sha256msg1,
        sha256msg2,
        shl,
        shld,
        shlx,
        shr,
        shrd,
        shrx,
        shufpd,
        shufps,
        sidt,
        sldt,
        smsw,
        sqrtpd,
        sqrtps,
        sqrtsd,
        sqrtss,
        stac,
        stc,
        std,
        sti,
        stmxcsr,
        stos,
        stosb,
        str,
        sub,
        subpd,
        subps,
        subsd,
        subss,
        swapgs,
        syscall,
        sysenter,
        sysexit,
        sysret,
        test,
        tzcnt,
        ucomisd,
        ucomiss,
        ud0,
        ud1,
        ud2,
        unpckhpd,
        unpckhps,
        unpcklpd,
        unpcklps,
        vaddpd,
        vaddps,
        vaddsd,
        vaddss,
        vaddsubpd,
        vaddsubps,
        vaesdec,
        vaesdeclast,
        vaesenc,
        vaesenclast,
        vaesimc,
        vaeskeygen,
        vandnpd,
        vandnps,
        vandpd,
        vandps,
        vblendpd,
        vblendps,
        vblendvb,
        vblendvpd,
        vblendvps,
        vblendw,
        vbroadcastb,
        vbroadcastf128,
        vbroadcastsd,
        vbroadcastss,
        vbroadcastw,
        vcmppd,
            vcmpeqpd,
            vcmpltpd,
            vcmplepd,
            vcmpunordpd,
            vcmpneqpd,
            vcmpnltpd,
            vcmpnlepd,
            vcmpordpd,
            vcmpeq_uqpd,
            vcmpngepd,
            vcmpngtpd,
            vcmpfalsepd,
            vcmpneq_oqpd,
            vcmpgepd,
            vcmpgtpd,
            vcmptruepd,
            vcmpeq_ospd,
            vcmplt_oqpd,
            vcmple_oqpd,
            vcmpunord_spd,
            vcmpneq_uspd,
            vcmpnlt_uqpd,
            vcmpnle_uqpd,
            vcmpord_spd,
            vcmpeq_uspd,
            vcmpnge_uqpd,
            vcmpngt_uqpd,
            vcmpfalse_ospd,
            vcmpneq_ospd,
            vcmpge_oqpd,
            vcmpgt_oqpd,
            vcmptrue_uspd,
        vcmpps,
            vcmpeqps,
            vcmpltps,
            vcmpleps,
            vcmpunordps,
            vcmpneqps,
            vcmpnltps,
            vcmpnleps,
            vcmpordps,
            vcmpeq_uqps,
            vcmpngeps,
            vcmpngtps,
            vcmpfalseps,
            vcmpneq_oqps,
            vcmpgeps,
            vcmpgtps,
            vcmptrueps,
            vcmpeq_osps,
            vcmplt_oqps,
            vcmple_oqps,
            vcmpunord_sps,
            vcmpneq_usps,
            vcmpnlt_uqps,
            vcmpnle_uqps,
            vcmpord_sps,
            vcmpeq_usps,
            vcmpnge_uqps,
            vcmpngt_uqps,
            vcmpfalse_osps,
            vcmpneq_osps,
            vcmpge_oqps,
            vcmpgt_oqps,
            vcmptrue_usps,
        vcmpsd,
            vcmpeqsd,
            vcmpltsd,
            vcmplesd,
            vcmpunordsd,
            vcmpneqsd,
            vcmpnltsd,
            vcmpnlesd,
            vcmpordsd,
            vcmpeq_uqsd,
            vcmpngesd,
            vcmpngtsd,
            vcmpfalsesd,
            vcmpneq_oqsd,
            vcmpgesd,
            vcmpgtsd,
            vcmptruesd,
            vcmpeq_ossd,
            vcmplt_oqsd,
            vcmple_oqsd,
            vcmpunord_ssd,
            vcmpneq_ussd,
            vcmpnlt_uqsd,
            vcmpnle_uqsd,
            vcmpord_ssd,
            vcmpeq_ussd,
            vcmpnge_uqsd,
            vcmpngt_uqsd,
            vcmpfalse_ossd,
            vcmpneq_ossd,
            vcmpge_oqsd,
            vcmpgt_oqsd,
            vcmptrue_ussd,
        vcmpss,
            vcmpeqss,
            vcmpltss,
            vcmpless,
            vcmpunordss,
            vcmpneqss,
            vcmpnltss,
            vcmpnless,
            vcmpordss,
            vcmpeq_uqss,
            vcmpngess,
            vcmpngtss,
            vcmpfalsess,
            vcmpneq_oqss,
            vcmpgess,
            vcmpgtss,
            vcmptruess,
            vcmpeq_osss,
            vcmplt_oqss,
            vcmple_oqss,
            vcmpunord_sss,
            vcmpneq_usss,
            vcmpnlt_uqss,
            vcmpnle_uqss,
            vcmpord_sss,
            vcmpeq_usss,
            vcmpnge_uqss,
            vcmpngt_uqss,
            vcmpfalse_osss,
            vcmpneq_osss,
            vcmpge_oqss,
            vcmpgt_oqss,
            vcmptrue_usss,

        vcomisd,
        vcomiss,
        vcvtdq2pd,
        vcvtdq2ps,
        vcvtpd2dq,
        vcvtpd2ps,
        vcvtpd2si,
        vcvtph2ps,
        vcvtpi2pd,
        vcvtpi2ps,
        vcvtps2dq,
        vcvtps2pd,
        vcvtps2ph,
        vcvtps2pi,
        vcvtqq2pd,
        vcvtsd2si,
        vcvtsd2ss,
        vcvtsi2sd,
        vcvtsi2ss,
        vcvtss2sd,
        vcvtss2si,
        vcvttpd2dq,
        vcvttpd2pi,
        vcvttps2dq,
        vcvttps2pi,
        vcvttps2udq,
        vcvttsd2si,
        vcvttss2si,
        vdivpd,
        vdivps,
        vdivsd,
        vdivss,
        vdppd,
        vdpps,
        verr,
        verw,
        vextractf128,
        vextracti128,
        vextractps,
        vextrw,
        vfmadd132pd,
        vfmadd132ps,
        vfmadd132sd,
        vfmadd132ss,
        vfmadd213pd,
        vfmadd213ps,
        vfmadd213sd,
        vfmadd213ss,
        vfmadd231pd,
        vfmadd231ps,
        vfmadd231sd,
        vfmadd231ss,
        vfmaddsub132pd,
        vfmaddsub132ps,
        vfmaddsub213pd,
        vfmaddsub213ps,
        vfmaddsub231pd,
        vfmaddsub231ps,
        vfmsub132pd,
        vfmsub132ps,
        vfmsub132sd,
        vfmsub132ss,
        vfmsub213pd,
        vfmsub213ps,
        vfmsub213ss,
        vfmsub213sd,
        vfmsub231pd,
        vfmsub231ps,
        vfmsub231ss,
        vfmsub231sd,

        vfmsubadd132pd,
        vfmsubadd132ps,
        vfmsubadd213pd,
        vfmsubadd213ps,
        vfmsubadd231pd,
        vfmsubadd231ps,

        vfnmadd132ps,
        vfnmadd132pd,
        vfnmadd132ss,
        vfnmadd132sd,
        vfnmadd213ps,
        vfnmadd213pd,
        vfnmadd213ss,
        vfnmadd213sd,
        vfnmadd231ps,
        vfnmadd231pd,
        vfnmadd231ss,
        vfnmadd231sd,
        vfnmsub132ps,
        vfnmsub132pd,
        vfnmsub132ss,
        vfnmsub132sd,
        vfnmsub213ps,
        vfnmsub213pd,
        vfnmsub213ss,
        vfnmsub213sd,
        vfnmsub231pd,
        vfnmsub231ps,
        vfnmsub231sd,
        vfnmsub231ss,

        vgatherdd,
        vgatherdpd,
        vgatherdps,
        vgatherdq,
        vgatherqd,
        vgatherqpd,
        vgatherqps,
        vgatherqq,
        vhaddpd,
        vhaddps,
        vhsubpd,
        vhsubps,
        vinserps,
        vinsertf128,
        vinsertf32x4,
        vinsertf64x2,
        vinserti128,
        vinserti32x4,
        vinserti64x2,
        vlddqu,
        vldmxcsr,
        vmaskmovdqu,
        vmaskmovpd,
        vmaskmovps,
        vmaxpd,
        vmaxps,
        vmaxsd,
        vmaxss,
        vmcall,
        vmclear,
        vmfunc,
        vminpd,
        vminps,
        vminsd,
        vminss,
        vmlaunch,
        vmovapd,
        vmovaps,
        vmovd,
        vmovddup,
        vmovdqa,
        vmovdqa32,
        vmovdqa64,
        vmovdqu,
        vmovdqu8,
        vmovdqu16,
        vmovdqu32,
        vmovdqu64,
        vmovhpd,
        vmovhps,
        vmovlhps,
        vmovlpd,
        vmovlps,
        vmovmskpd,
        vmovmskps,
        vmovntdq,
        vmovntdqa,
        vmovntpd,
        vmovntps,
        vmovntq,
        vmovq,
        vmovsd,
        vmovshdup,
        vmovsldup,
        vmovss,
        vmovupd,
        vmovups,
        vmpsadbw,
        vmptrld,
        vmptrst,
        vmread,
        vmresume,
        vmulpd,
        vmulps,
        vmulsd,
        vmulss,
        vmwrite,
        vmxoff,
        vmxon,
        vorpd,
        vorps,
        vpabsb,
        vpabsd,
        vpabsq,
        vpabsw,
        vpackssdw,
        vpacksswb,
        vpackusdw,
        vpackuswb,
        vpaddb,
        vpaddd,
        vpaddq,
        vpaddsb,
        vpaddsw,
        vpaddusb,
        vpaddusw,
        vpaddw,
        vpand,
        vpandd,
        vpandq,
        vpandn,
        vpandnd,
        vpandnq,
        vpavgb,
        vpavgw,
        vpblendd,
        vpblendw,
        vpbroadcastb,
        vpbroadcastd,
        vpbroadcasti128,
        vpbroadcastq,
        vpbroadcastw,
        vpclmulqdq,
        vpcmpeqb,
        vpcmpeqd,
        vpcmpeqq,
        vpcmpeqw,
        vpcmpestri,
        vpcmpestrm,
        vpcmpgtb,
        vpcmpgtd,
        vpcmpgtq,
        vpcmpgtw,
        vpcmpistri,
        vpcmpistrm,
        vperm2f128,
        vperm2i128,
        vpermd,
        vpermilpd,
        vpermilps,
        vpermpd,
        vpermps,
        vpermq,
        vpermt2pd,
        vpermt2ps,
        vpextrb,
        vpextrd,
        vpextrq,
        vpextrw,
        vphaddd,
        vphaddsw,
        vphaddw,
        vphminposuw,
        vphsubd,
        vphsubsw,
        vphsubw,
        vpinsrb,
        vpinsrd,
        vpinsrq,
        vpinsrw,
        vpmaddubsw,
        vpmaddwd,
        vpmaskmovd,
        vpmaskmovq,
        vpmaxsb,
        vpmaxsd,
        vpmaxsq,
        vpmaxsw,
        vpmaxub,
        vpmaxud,
        vpmaxuq,
        vpmaxuw,
        vpminsb,
        vpminsd,
        vpminsq,
        vpminsw,
        vpminub,
        vpminud,
        vpminuw,
        vpmovmskb,
        vpmovsxbd,
        vpmovsxbq,
        vpmovsxbw,
        vpmovsxdq,
        vpmovsxwd,
        vpmovsxwq,
        vpmovzxbd,
        vpmovzxbq,
        vpmovzxbw,
        vpmovzxdq,
        vpmovzxwd,
        vpmovzxwq,
        vpmuldq,
        vpmulhrsw,
        vpmulhuw,
        vpmulhw,
        vpmulld,
        vpmullq,
        vpmullw,
        vpmuludq,
        vpor,
        vpord,
        vporq,
        vprolvd,
        vprolvq,
        vprorvd,
        vprorvq,
        vpsadbw,
        vpshufb,
        vpshufd,
        vpshufhw,
        vpshuflw,
        vpsignb,
        vpsignd,
        vpsignw,
        vpslld,
        vpslldq,
        vpsllq,
        vpsllvd,
        vpsllvq,
        vpsllw,
        vpsrad,
        vpsraq,
        vpsravd,
        vpsravq,
        vpsraw,
        vpsrld,
        vpsrldq,
        vpsrlq,
        vpsrlvd,
        vpsrlvq,
        vpsrlw,
        vpsubb,
        vpsubd,
        vpsubq,
        vpsubsb,
        vpsubsw,
        vpsubusb,
        vpsubusw,
        vpsubw,
        vptest,
        vpunpckhbw,
        vpunpckhdq,
        vpunpckhqdq,
        vpunpckhwd,
        vpunpcklbw,
        vpunpckldq,
        vpunpcklqdq,
        vpunpcklwd,
        vpxor,
        vpxord,
        vpxorq,
        vrcpps,
        vrcpss,
        vrndscalepd,
        vrndscaleps,
        vrndscalesd,
        vrndscaless,
        vroundpd,
        vroundps,
        vroundsd,
        vroundss,
        vrsqrt14ps,
        vrsqrt14pd,
        vrsqrtps,
        vrsqrtss,
        vshufpd,
        vshufps,
        vsqrtpd,
        vsqrtps,
        vsqrtsd,
        vsqrtss,
        vstmxcsr,
        vsubpd,
        vsubps,
        vsubsd,
        vsubss,
        vtestpd,
        vtestps,
        vucomisd,
        vucomiss,
        vunpckhpd,
        vunpckhps,
        vunpcklpd,
        vunpcklps,
        vxorpd,
        vxorps,
        vzeroall,
        vzeroupper,
        wait,
        wbinvd,
        wrmsr,
        wrpkru,
        xabort,
        xadd,
        xchg,
        xend,
        xgetbv,
        xlat,
        xor,
        xorpd,
        xorps,
        xrstor,
        xrstor64,
        xsave,
        xsave64,
        xsaveopt,
        xsaveopt64,
        xsetbv,
        xtest,

        // Borland implemented an x87 emulator, and introduced these
        // pseudo-instructions.
        BOR_exp,
        BOR_ln,
    }
}
