#region License
/* 
 * Copyright (C) 1999-2023 John Källén.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using Reko.Core.Services;
using Reko.Gui.Services;
using System;
using System.Threading.Tasks;

namespace Reko.Gui.Commands
{
    public abstract class Command : ICommand
    {
        public Command(IServiceProvider services)
        {
            this.Services = services;
        }

        public bool IsUndoable { get; protected set; }
        public IServiceProvider Services { get; private set; }

        public async ValueTask DoAsync()
        {
            try
            {
                await DoItAsync();
            }
            catch (Exception ex)
            {
                await Services.RequireService<IDecompilerShellUiService>()
                    .ShowError(ex, "An error occurred.");
            }
        }

        public abstract ValueTask DoItAsync();

        public virtual void Undo()
        {
        }
    }
}
