#region License
/* 
 * Copyright (C) 1999-2023 John Klln.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#endregion

using Reko.Core;
using Reko.Core.Expressions;
using Reko.Core.Types;
using NUnit.Framework;
using System;

namespace Reko.UnitTests.Core
{
	[TestFixture]
	public class CastTests
	{
		[Test]
		public void CastCreate()
		{
			var cast = new Cast(PrimitiveType.Word32, Constant.Real32(3.0F));
			var p = (PrimitiveType) cast.DataType;
			Assert.AreEqual(PrimitiveType.Word32, p);
			Assert.AreEqual(PrimitiveType.Real32, cast.Expression.DataType);
		}
	}
}
