﻿using System;

namespace Swan.Configuration
{
    /// <summary>
    /// An attribute used to include additional information to a Property for serialization.
    /// 
    /// Previously we used DisplayAttribute from DataAnnotation.
    /// </summary>
    /// <seealso cref="System.Attribute" />
    [AttributeUsage(AttributeTargets.Property)]
    public sealed class PropertyDisplayAttribute : Attribute
    {
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string? Name { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        public string? Description { get; set; }

        /// <summary>
        /// Gets or sets the name of the group.
        /// </summary>
        /// <value>
        /// The name of the group.
        /// </value>
        public string? GroupName { get; set; }

        /// <summary>
        /// Gets or sets the default value.
        /// </summary>
        /// <value>
        /// The default value.
        /// </value>
        public object? DefaultValue { get; set; }

        /// <summary>
        /// Gets or sets the format string to call with method <c>ToString</c>.
        /// </summary>
        /// <value>
        /// The format.
        /// </value>
        public string? Format { get; set; }
    }
}
