from dokusan import renderers, techniques
from dokusan.boards import BoxSize, Sudoku


def test_plain():
    expected = (
        "┌─────────┬─────────┬─────────╥─────────┬─────────┬─────────╥─────────┬─────────┬─────────┐\n"  # noqa: E501
        "│    2  3 │    2  3 │    2    ║       3 │         │       3 ║         │         │         │\n"  # noqa: E501
        "│    5    │ 4  5  6 │    5  6 ║ 4  5  6 │    9    │ 4  5  6 ║    1    │       6 │ 4     6 │\n"  # noqa: E501
        "│         │    8    │    8    ║ 7  8    │         │ 7       ║         │ 7       │ 7       │\n"  # noqa: E501
        "├─────────┼─────────┼─────────╫─────────┼─────────┼─────────╫─────────┼─────────┼─────────┤\n"  # noqa: E501
        "│         │         │ 1       ║         │         │         ║         │         │         │\n"  # noqa: E501
        "│    5    │ 4  5  6 │    5  6 ║ 4  5  6 │ 4  5    │    2    ║    3    │       6 │ 4     6 │\n"  # noqa: E501
        "│         │    8  9 │    8    ║ 7  8    │ 7  8    │         ║         │ 7     9 │ 7     9 │\n"  # noqa: E501
        "├─────────┼─────────┼─────────╫─────────┼─────────┼─────────╫─────────┼─────────┼─────────┤\n"  # noqa: E501
        "│       3 │       3 │         ║       3 │         │         ║         │         │         │\n"  # noqa: E501
        "│         │ 4     6 │    7    ║ 4     6 │ 4       │    1    ║    8    │    2    │    5    │\n"  # noqa: E501
        "│         │       9 │         ║         │         │         ║         │         │         │\n"  # noqa: E501
        "╞═════════╪═════════╪═════════╬═════════╪═════════╪═════════╬═════════╪═════════╪═════════╡\n"  # noqa: E501
        "│         │    2    │         ║ 1  2    │         │         ║         │ 1       │    2    │\n"  # noqa: E501
        "│    6    │    5    │    4    ║    5    │    3    │    8    ║    9    │    5    │         │\n"  # noqa: E501
        "│         │         │         ║ 7       │         │         ║         │ 7       │ 7       │\n"  # noqa: E501
        "├─────────┼─────────┼─────────╫─────────┼─────────┼─────────╫─────────┼─────────┼─────────┤\n"  # noqa: E501
        "│         │         │    2    ║    2    │    2    │         ║    2    │       3 │    2    │\n"  # noqa: E501
        "│    8    │    1    │    5    ║ 4  5  6 │ 4  5    │ 4  5  6 ║ 4  5    │    5  6 │ 4     6 │\n"  # noqa: E501
        "│         │         │         ║ 7     9 │ 7       │ 7     9 ║         │ 7       │ 7       │\n"  # noqa: E501
        "├─────────┼─────────┼─────────╫─────────┼─────────┼─────────╫─────────┼─────────┼─────────┤\n"  # noqa: E501
        "│    2  3 │    2  3 │         ║ 1  2    │    2    │         ║    2    │ 1     3 │         │\n"  # noqa: E501
        "│    5    │    5    │    9    ║ 4  5  6 │ 4  5    │ 4  5  6 ║ 4  5    │    5  6 │    8    │\n"  # noqa: E501
        "│ 7       │         │         ║ 7       │ 7       │ 7       ║         │ 7       │         │\n"  # noqa: E501
        "╞═════════╪═════════╪═════════╬═════════╪═════════╪═════════╬═════════╪═════════╪═════════╡\n"  # noqa: E501
        "│         │         │    2    ║    2  3 │    2    │       3 ║         │         │    2    │\n"  # noqa: E501
        "│    1    │    7    │    5    ║ 4  5    │ 4  5    │ 4  5    ║    6    │    5    │         │\n"  # noqa: E501
        "│         │         │    8    ║    8  9 │    8    │       9 ║         │    8  9 │       9 │\n"  # noqa: E501
        "├─────────┼─────────┼─────────╫─────────┼─────────┼─────────╫─────────┼─────────┼─────────┤\n"  # noqa: E501
        "│         │    2    │    2    ║    2    │         │         ║         │         │         │\n"  # noqa: E501
        "│    9    │    5  6 │    5  6 ║    5    │    1    │    5    ║    7    │    4    │    3    │\n"  # noqa: E501
        "│         │    8    │    8    ║    8    │         │         ║         │         │         │\n"  # noqa: E501
        "├─────────┼─────────┼─────────╫─────────┼─────────┼─────────╫─────────┼─────────┼─────────┤\n"  # noqa: E501
        "│         │    2    │         ║    2    │         │         ║    2    │         │         │\n"  # noqa: E501
        "│    4    │    5    │    3    ║    5    │    6    │    5    ║    5    │    5    │    1    │\n"  # noqa: E501
        "│         │    8    │         ║ 7  8  9 │         │ 7     9 ║         │    8  9 │         │\n"  # noqa: E501
        "└─────────┴─────────┴─────────╨─────────┴─────────┴─────────╨─────────┴─────────┴─────────┘"  # noqa: E501
    )

    sudoku = Sudoku.from_list(
        [
            [0, 0, 0, 0, 9, 0, 1, 0, 0],
            [0, 0, 0, 0, 0, 2, 3, 0, 0],
            [0, 0, 7, 0, 0, 1, 8, 2, 5],
            [6, 0, 4, 0, 3, 8, 9, 0, 0],
            [8, 1, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 9, 0, 0, 0, 0, 0, 8],
            [1, 7, 0, 0, 0, 0, 6, 0, 0],
            [9, 0, 0, 0, 1, 0, 7, 4, 3],
            [4, 0, 3, 0, 6, 0, 0, 0, 1],
        ],
        box_size=BoxSize(3, 3),
    )
    sudoku.update(techniques.BulkPencilMarking(sudoku).first().changes)
    assert renderers.plain(sudoku) == expected


def test_colorful():
    sudoku = Sudoku.from_list(
        [
            [0, 0, 0, 0, 9, 0, 1, 0, 0],
            [0, 0, 0, 0, 0, 2, 3, 0, 0],
            [0, 0, 7, 0, 0, 1, 8, 2, 5],
            [6, 0, 4, 0, 3, 8, 9, 0, 0],
            [8, 1, 0, 0, 0, 0, 0, 0, 0],
            [0, 0, 9, 0, 0, 0, 0, 0, 8],
            [1, 7, 0, 0, 0, 0, 6, 0, 0],
            [9, 0, 0, 0, 1, 0, 7, 4, 3],
            [4, 0, 3, 0, 6, 0, 0, 0, 1],
        ],
        box_size=BoxSize(3, 3),
    )
    sudoku.update(techniques.BulkPencilMarking(sudoku).first().changes)
    assert "\033[93m2\033[0m" in renderers.colorful(sudoku)
