# Your privacy

Even though Kap is open-source and not in the business of monetizing the product itself nor your data, directly or indirectly, we feel it's important to share how we think about, collect and use insights we gain on how Kap is used through certain [third party services](#third-party-services).

The short version is that we respect your privacy, aim to give you as much choice and control as possible, and try to gather only the minimum amount of data absolutely necessary to help us make Kap better for you and everyone else.

### Security

All our traffic is served over [HTTPS](https://en.wikipedia.org/wiki/HTTPS). Our SSL/TLS certificate is issued by [Let's Encrypt](https://letsencrypt.org). In addition to encryption, we do our best to stay vigilant and implement precautionary measures to avoid breaches or misuse.

### Cookies

We do not allow any [third-party cookies](https://en.wikipedia.org/wiki/HTTP_cookie#Third-party_cookie) and do not attempt to identify you, track you or associate your data across devices and services, nor do we use cookies to serve advertising.

**Authorised cookies:**
- `_g` for Google Analytics
- `_gat_gtag_UA_84705099_3` for Google Analytics
- `_gid` for Google Analytics

You are of course free to block and remove cookies. You will typically find these options in the address bar of your browser.

[Learn more about our use of Google Analytics](#google-analytics-gdpr-compliant).

## Third-party services

An overview of third-party services that have access to, collect or generate data based on your usage.

### Google Analytics (GDPR Compliant)

We do not (and do not allow third-parties to) use our Google Analytics data to track or collect personally identifiable information, nor do we (or do we allow any third-party to) associate data gathered with any personally identifying information from any source.

[Google Analytics data is not shared with other Google products and services](https://support.google.com/analytics/answer/1011397), and is not accessible to Google technical support representatives or Google marketing specialists.

We do not collect or use [user specific metrics](https://support.google.com/analytics/answer/2992042), nor do we [associate data from different devices](https://support.google.com/analytics/answer/3123662).

No [Enhanced Link Attribution](https://support.google.com/analytics/answer/7377126) or [Demographics and Interests reports](https://support.google.com/analytics/answer/2799357) are used or generated, nor do we [track your search queries on our site](https://support.google.com/analytics/answer/1012264). We also do not collect data for [Display and Search Remarketing or Advertising Reporting features](https://support.google.com/analytics/answer/3450482).

Google Analytics data for inactive sessions are retained for the [shortest currently available time](https://support.google.com/analytics/answer/7667196) (14 months). We can however retain analytics data for active sessions longer.

We ask Google Analytics to [anonymize your IP address](https://support.google.com/analytics/answer/2763052).

- [Google Privacy Policy](https://policies.google.com/privacy)
- [How Google Analytics safeguards your data](https://support.google.com/analytics/answer/6004245)
- [Privacy Shield Certificate](https://www.privacyshield.gov/participant?id=a2zt000000001L5AAI)

### Sentry (GDPR Compliant)

We prevent Sentry from storing IP Addresses, in addition to requiring enhanced privacy controls and data scrubbers be applied to prevent [sensitive data](https://docs.sentry.io/learn/sensitive-data/) being stored.

- [Security & Compliance at Sentry](https://sentry.io/security/)
- [GDPR, Sentry, and You](https://blog.sentry.io/2018/03/14/gdpr-sentry-and-you)
- [Privacy Shield Certificate](https://www.privacyshield.gov/participant?id=a2zt0000000TNDzAAO)

### MailChimp (GDPR Compliant)

We are compliant with [MailChimp Terms of Use and anti-spam requirements](https://kb.mailchimp.com/accounts/compliance-tips/terms-of-use-and-anti-spam-requirements) (CAN-SPAM).

When you provide your name and email address to [receive email updates](http://eepurl.com/ch90_1) from us, you acknowledge that the information you provide will be transferred to MailChimp for processing in accordance with their [Privacy Policy](https://mailchimp.com/legal/privacy/) and [Terms](https://mailchimp.com/legal/terms/).

We do not allow MailChimp to use your information in their data science projects.

You can unsubscribe from emails regarding Kap at any time by using the unsubscribe link in the footer of any email you receive from us, or by contacting us at hello@wulkano.com.

- [About MailChimp, the EU/Swiss Privacy Shield, and the GDPR](https://kb.mailchimp.com/accounts/management/about-mailchimp-the-eu-swiss-privacy-shield-and-the-gdpr)
- [Privacy Shield Certificate](https://www.privacyshield.gov/participant?id=a2zt0000000TO6hAAG)

## Help us do even better

We'd love to hear from you! [Open an issue](https://github.com/wulkano/kap/issues/new) or [send an email](mailto:hello@wulkano.com) to help shape and strengthen our stance on privacy.

*Updated May 24, 2018*
