//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by defaulter-gen. DO NOT EDIT.

package v1alpha1

import (
	runtime "k8s.io/apimachinery/pkg/runtime"
)

// RegisterDefaults adds defaulters functions to the given scheme.
// Public to allow building arbitrary schemes.
// All generated defaulters are covering - they call all nested defaulters.
func RegisterDefaults(scheme *runtime.Scheme) error {
	scheme.AddTypeDefaultingFunc(&KwokConfiguration{}, func(obj interface{}) { SetObjectDefaults_KwokConfiguration(obj.(*KwokConfiguration)) })
	scheme.AddTypeDefaultingFunc(&KwokctlConfiguration{}, func(obj interface{}) { SetObjectDefaults_KwokctlConfiguration(obj.(*KwokctlConfiguration)) })
	return nil
}

func SetObjectDefaults_KwokConfiguration(in *KwokConfiguration) {
	if in.Options.CIDR == "" {
		in.Options.CIDR = "10.0.0.1/24"
	}
	if in.Options.ManageAllNodes == nil {
		var ptrVar1 bool = false
		in.Options.ManageAllNodes = &ptrVar1
	}
	if in.Options.EnableCNI == nil {
		var ptrVar1 bool = false
		in.Options.EnableCNI = &ptrVar1
	}
	if in.Options.EnableDebuggingHandlers == nil {
		var ptrVar1 bool = true
		in.Options.EnableDebuggingHandlers = &ptrVar1
	}
	if in.Options.EnableContentionProfiling == nil {
		var ptrVar1 bool = false
		in.Options.EnableContentionProfiling = &ptrVar1
	}
	if in.Options.EnableProfilingHandler == nil {
		var ptrVar1 bool = true
		in.Options.EnableProfilingHandler = &ptrVar1
	}
	if in.Options.PodPlayStageParallelism == 0 {
		in.Options.PodPlayStageParallelism = 4
	}
	if in.Options.NodePlayStageParallelism == 0 {
		in.Options.NodePlayStageParallelism = 4
	}
	if in.Options.NodeLeaseParallelism == 0 {
		in.Options.NodeLeaseParallelism = 4
	}
}

func SetObjectDefaults_KwokctlConfiguration(in *KwokctlConfiguration) {
	if in.Options.QuietPull == nil {
		var ptrVar1 bool = false
		in.Options.QuietPull = &ptrVar1
	}
	if in.Options.DisableKubeScheduler == nil {
		var ptrVar1 bool = false
		in.Options.DisableKubeScheduler = &ptrVar1
	}
	if in.Options.DisableKubeControllerManager == nil {
		var ptrVar1 bool = false
		in.Options.DisableKubeControllerManager = &ptrVar1
	}
	if in.Options.EnableMetricsServer == nil {
		var ptrVar1 bool = false
		in.Options.EnableMetricsServer = &ptrVar1
	}
	if in.Options.EtcdPrefix == "" {
		in.Options.EtcdPrefix = "/registry"
	}
	if in.Options.KubeControllerManagerNodeMonitorPeriodMilliseconds == 0 {
		in.Options.KubeControllerManagerNodeMonitorPeriodMilliseconds = 5000
	}
	if in.Options.KubeControllerManagerNodeMonitorGracePeriodMilliseconds == 0 {
		in.Options.KubeControllerManagerNodeMonitorGracePeriodMilliseconds = 40000
	}
	if in.Options.NodeStatusUpdateFrequencyMilliseconds == 0 {
		in.Options.NodeStatusUpdateFrequencyMilliseconds = 10000
	}
	if in.Options.NodeLeaseDurationSeconds == 0 {
		in.Options.NodeLeaseDurationSeconds = 40
	}
	if in.Options.HeartbeatFactor == nil {
		var ptrVar1 float64 = 5
		in.Options.HeartbeatFactor = &ptrVar1
	}
	if in.Options.BindAddress == "" {
		in.Options.BindAddress = "0.0.0.0"
	}
	if in.Options.DisableQPSLimits == nil {
		var ptrVar1 bool = false
		in.Options.DisableQPSLimits = &ptrVar1
	}
	if in.Options.EtcdQuotaBackendSize == "" {
		in.Options.EtcdQuotaBackendSize = "8Gi"
	}
	for i := range in.Components {
		a := &in.Components[i]
		for j := range a.Ports {
			b := &a.Ports[j]
			if b.Protocol == "" {
				b.Protocol = "TCP"
			}
		}
	}
}
