/*
Copyright 2023 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package resources

type filterGetter[O any, T any] struct {
	getter     Getter[T]
	filterFunc func(T) O
}

// NewFilter returns a new Getter that returns the given list.
func NewFilter[O any, T any](getter Getter[T], filterFunc func(T) O) Getter[O] {
	return withCache[O](&filterGetter[O, T]{getter: getter, filterFunc: filterFunc})
}

func (f *filterGetter[O, T]) Get() O {
	return f.filterFunc(f.getter.Get())
}

func (f *filterGetter[O, T]) Version() string {
	return f.getter.Version()
}
