/*
Copyright 2023 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package resources

import (
	"context"
)

// Getter is an interface for getting resources.
type Getter[O any] interface {
	Get() O
	Version() string
}

// DynamicGetter is an interface for getting resources.
type DynamicGetter[O any] interface {
	Getter[O]
	Starter
	Synced
}

// Starter is an interface for starting resources.
type Starter interface {
	Start(ctx context.Context) error
}

// CacheGetter is an interface for getting resources that are cached.
type CacheGetter[O any] interface {
	Getter[O]
}

// Synced is an interface for getting resources that are synced.
type Synced interface {
	Sync() <-chan struct{}
}
