/*
Copyright 2023 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package etcd

// Don't edit this file directly. It is generated by scheme.sh.
import (
	admissionregistrationv1 "k8s.io/api/admissionregistration/v1"
	admissionregistrationv1alpha1 "k8s.io/api/admissionregistration/v1alpha1"
	admissionregistrationv1beta1 "k8s.io/api/admissionregistration/v1beta1"
	apidiscoveryv2 "k8s.io/api/apidiscovery/v2"
	apidiscoveryv2beta1 "k8s.io/api/apidiscovery/v2beta1"
	apiserverinternalv1alpha1 "k8s.io/api/apiserverinternal/v1alpha1"
	appsv1 "k8s.io/api/apps/v1"
	appsv1beta1 "k8s.io/api/apps/v1beta1"
	appsv1beta2 "k8s.io/api/apps/v1beta2"
	authenticationv1 "k8s.io/api/authentication/v1"
	authenticationv1alpha1 "k8s.io/api/authentication/v1alpha1"
	authenticationv1beta1 "k8s.io/api/authentication/v1beta1"
	authorizationv1 "k8s.io/api/authorization/v1"
	authorizationv1beta1 "k8s.io/api/authorization/v1beta1"
	autoscalingv1 "k8s.io/api/autoscaling/v1"
	autoscalingv2 "k8s.io/api/autoscaling/v2"
	autoscalingv2beta1 "k8s.io/api/autoscaling/v2beta1"
	autoscalingv2beta2 "k8s.io/api/autoscaling/v2beta2"
	batchv1 "k8s.io/api/batch/v1"
	batchv1beta1 "k8s.io/api/batch/v1beta1"
	certificatesv1 "k8s.io/api/certificates/v1"
	certificatesv1alpha1 "k8s.io/api/certificates/v1alpha1"
	certificatesv1beta1 "k8s.io/api/certificates/v1beta1"
	coordinationv1 "k8s.io/api/coordination/v1"
	coordinationv1alpha2 "k8s.io/api/coordination/v1alpha2"
	coordinationv1beta1 "k8s.io/api/coordination/v1beta1"
	corev1 "k8s.io/api/core/v1"
	discoveryv1 "k8s.io/api/discovery/v1"
	discoveryv1beta1 "k8s.io/api/discovery/v1beta1"
	eventsv1 "k8s.io/api/events/v1"
	eventsv1beta1 "k8s.io/api/events/v1beta1"
	extensionsv1beta1 "k8s.io/api/extensions/v1beta1"
	flowcontrolv1 "k8s.io/api/flowcontrol/v1"
	flowcontrolv1beta1 "k8s.io/api/flowcontrol/v1beta1"
	flowcontrolv1beta2 "k8s.io/api/flowcontrol/v1beta2"
	flowcontrolv1beta3 "k8s.io/api/flowcontrol/v1beta3"
	imagepolicyv1alpha1 "k8s.io/api/imagepolicy/v1alpha1"
	networkingv1 "k8s.io/api/networking/v1"
	networkingv1alpha1 "k8s.io/api/networking/v1alpha1"
	networkingv1beta1 "k8s.io/api/networking/v1beta1"
	nodev1 "k8s.io/api/node/v1"
	nodev1alpha1 "k8s.io/api/node/v1alpha1"
	nodev1beta1 "k8s.io/api/node/v1beta1"
	policyv1 "k8s.io/api/policy/v1"
	policyv1beta1 "k8s.io/api/policy/v1beta1"
	rbacv1 "k8s.io/api/rbac/v1"
	rbacv1alpha1 "k8s.io/api/rbac/v1alpha1"
	rbacv1beta1 "k8s.io/api/rbac/v1beta1"
	resourcev1alpha3 "k8s.io/api/resource/v1alpha3"
	resourcev1beta1 "k8s.io/api/resource/v1beta1"
	schedulingv1 "k8s.io/api/scheduling/v1"
	schedulingv1alpha1 "k8s.io/api/scheduling/v1alpha1"
	schedulingv1beta1 "k8s.io/api/scheduling/v1beta1"
	storagev1 "k8s.io/api/storage/v1"
	storagev1alpha1 "k8s.io/api/storage/v1alpha1"
	storagev1beta1 "k8s.io/api/storage/v1beta1"
	storagemigrationv1alpha1 "k8s.io/api/storagemigration/v1alpha1"
	"k8s.io/apimachinery/pkg/runtime"
)

// AddToScheme adds all types of this clientset into the given scheme.
func AddToScheme(scheme *runtime.Scheme) {
	_ = admissionregistrationv1.AddToScheme(scheme)
	_ = admissionregistrationv1alpha1.AddToScheme(scheme)
	_ = admissionregistrationv1beta1.AddToScheme(scheme)
	_ = apidiscoveryv2.AddToScheme(scheme)
	_ = apidiscoveryv2beta1.AddToScheme(scheme)
	_ = apiserverinternalv1alpha1.AddToScheme(scheme)
	_ = appsv1.AddToScheme(scheme)
	_ = appsv1beta1.AddToScheme(scheme)
	_ = appsv1beta2.AddToScheme(scheme)
	_ = authenticationv1.AddToScheme(scheme)
	_ = authenticationv1alpha1.AddToScheme(scheme)
	_ = authenticationv1beta1.AddToScheme(scheme)
	_ = authorizationv1.AddToScheme(scheme)
	_ = authorizationv1beta1.AddToScheme(scheme)
	_ = autoscalingv1.AddToScheme(scheme)
	_ = autoscalingv2.AddToScheme(scheme)
	_ = autoscalingv2beta1.AddToScheme(scheme)
	_ = autoscalingv2beta2.AddToScheme(scheme)
	_ = batchv1.AddToScheme(scheme)
	_ = batchv1beta1.AddToScheme(scheme)
	_ = certificatesv1.AddToScheme(scheme)
	_ = certificatesv1alpha1.AddToScheme(scheme)
	_ = certificatesv1beta1.AddToScheme(scheme)
	_ = coordinationv1.AddToScheme(scheme)
	_ = coordinationv1alpha2.AddToScheme(scheme)
	_ = coordinationv1beta1.AddToScheme(scheme)
	_ = corev1.AddToScheme(scheme)
	_ = discoveryv1.AddToScheme(scheme)
	_ = discoveryv1beta1.AddToScheme(scheme)
	_ = eventsv1.AddToScheme(scheme)
	_ = eventsv1beta1.AddToScheme(scheme)
	_ = extensionsv1beta1.AddToScheme(scheme)
	_ = flowcontrolv1.AddToScheme(scheme)
	_ = flowcontrolv1beta1.AddToScheme(scheme)
	_ = flowcontrolv1beta2.AddToScheme(scheme)
	_ = flowcontrolv1beta3.AddToScheme(scheme)
	_ = imagepolicyv1alpha1.AddToScheme(scheme)
	_ = networkingv1.AddToScheme(scheme)
	_ = networkingv1alpha1.AddToScheme(scheme)
	_ = networkingv1beta1.AddToScheme(scheme)
	_ = nodev1.AddToScheme(scheme)
	_ = nodev1alpha1.AddToScheme(scheme)
	_ = nodev1beta1.AddToScheme(scheme)
	_ = policyv1.AddToScheme(scheme)
	_ = policyv1beta1.AddToScheme(scheme)
	_ = rbacv1.AddToScheme(scheme)
	_ = rbacv1alpha1.AddToScheme(scheme)
	_ = rbacv1beta1.AddToScheme(scheme)
	_ = resourcev1alpha3.AddToScheme(scheme)
	_ = resourcev1beta1.AddToScheme(scheme)
	_ = schedulingv1.AddToScheme(scheme)
	_ = schedulingv1alpha1.AddToScheme(scheme)
	_ = schedulingv1beta1.AddToScheme(scheme)
	_ = storagemigrationv1alpha1.AddToScheme(scheme)
	_ = storagev1.AddToScheme(scheme)
	_ = storagev1alpha1.AddToScheme(scheme)
	_ = storagev1beta1.AddToScheme(scheme)
}
