# Contributing to swhkd

1. Fork the repo and create your branch from `main`.
1. Make sure to write tests for the functions you make.
1. Run `make check` once you're done and ensure the test suite passes.

## Any contributions you make will be under the BSD-2-Clause Software License
In short, when you submit code changes, your submissions are understood to be under the same BSD-2-Clause License that covers the project. Feel free to contact the maintainers if that's a concern.

## Use a Consistent Coding Style
I'm again borrowing these from [Facebook's Guidelines](https://github.com/facebook/draft-js/blob/a9316a723f9e918afde44dea68b5f9f39b7d9b00/CONTRIBUTING.md)

* 4 spaces for indentation.
* You can run `make check` for style unification.

## Proper Commit Messages
Make sure to write proper commit messages. 

Example: `[refactor] daemon.rs, simpler IPC implementation`.

## License
By contributing, you agree that your contributions will be licensed under its BSD-2-Clause License.

## References
This document was adapted from [GitHub Gist](https://gist.github.com/briandk/3d2e8b3ec8daf5a27a62).
