% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBenchmarkResult.R
\name{plotBenchmarkResult}
\alias{plotBenchmarkResult}
\title{Create a Trellis-plot for a selected measure.}
\usage{
plotBenchmarkResult(bmr, measure = NULL, style = "box", order.lrns = NULL,
  order.tsks = NULL, pretty.names = TRUE)
}
\arguments{
\item{bmr}{[\code{\link{BenchmarkResult}}]\cr
Benchmark result.}

\item{measure}{[\code{\link{Measure}}]\cr
Performance measure.
Default is the default measure for the task, see here \code{\link{getDefaultMeasure}}.}

\item{style}{[\code{character(1)}]\cr
Type of plot, can be \dQuote{box} for a boxplot or \dQuote{violin} for
a violin-plot.
Default is \dQuote{box}.}

\item{order.lrns}{[\code{character(n.learners)}]\cr 
Character vector with \code{learner.ids} in new order.}

\item{order.tsks}{[\code{character(n.tasks)}] \cr 
Character vector with \code{task.ids} in new order.}

\item{pretty.names}{[\code{logical(1)}]\cr
Whether to use the \code{\link{Measure}} name instead of the id in the plot.
Default is \code{TRUE}.}
}
\value{
ggplot2 plot object.
}
\description{
Plots boxplots for a selected \code{measure} across all iterations
of the resampling strategy, faceted by the \code{task.id}
}
\examples{
lrns = list(makeLearner("classif.nnet"), makeLearner("classif.rpart"))
tasks = list(iris.task, sonar.task)
rdesc = makeResampleDesc("CV", iters = 2L)
meas = list(acc, mmce, ber, featperc)
res = benchmark(lrns, tasks, rdesc, meas)
plotBenchmarkResult(res, acc)

}
\references{
Manuel J. A. Eugster, Torsten Hothorn and Friedrich Leisch;
Domain-Based Benchmark Experiments: Exploratory and Inferential Analysis,
AUSTRIAN JOURNAL OF STATISTICS Volume 41 (2012), Number 1, 5–26,
but does not include any clustering or sorting.
}
\seealso{
Other benchmark: \code{\link{BenchmarkResult}},
  \code{\link{benchmark}},
  \code{\link{convertBMRToRankMatrix}},
  \code{\link{friedmanPostHocTestBMR}},
  \code{\link{friedmanTestBMR}},
  \code{\link{generateBenchmarkSummaryData}},
  \code{\link{generateCritDifferencesData}},
  \code{\link{generateRankMatrixAsBarData}},
  \code{\link{getBMRAggrPerformances}},
  \code{\link{getBMRFeatSelResults}},
  \code{\link{getBMRFilteredFeatures}},
  \code{\link{getBMRLearnerIds}},
  \code{\link{getBMRLearners}},
  \code{\link{getBMRMeasureIds}},
  \code{\link{getBMRMeasures}},
  \code{\link{getBMRPerformances}},
  \code{\link{getBMRPredictions}},
  \code{\link{getBMRTaskIds}},
  \code{\link{getBMRTuneResults}},
  \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotRankMatrixAsBar}}

Other plot: \code{\link{plotBenchmarkSummary}},
  \code{\link{plotCalibration}},
  \code{\link{plotCritDifferences}},
  \code{\link{plotFilterValuesGGVIS}},
  \code{\link{plotFilterValues}},
  \code{\link{plotLearningCurveGGVIS}},
  \code{\link{plotLearningCurve}},
  \code{\link{plotPartialPredictionGGVIS}},
  \code{\link{plotPartialPrediction}},
  \code{\link{plotROCCurves}},
  \code{\link{plotROCRCurvesGGVIS}},
  \code{\link{plotROCRCurves}},
  \code{\link{plotRankMatrixAsBar}},
  \code{\link{plotThreshVsPerfGGVIS}},
  \code{\link{plotThreshVsPerf}}
}

