import json
import requests
import time

headers = {
    "User-Agent": "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/75.0.3770.100 Safari/537.36"
}

opml_file = open("blogs.opml.xml", "w", encoding='utf8')
print("""<?xml version="1.0" encoding="UTF-8"?>
<opml version="2.0">
<head>
  <title>中文博客列表导航项目</title>
  <dateCreated>""" + time.asctime(time.localtime(time.time())) + """</dateCreated>
</head>
<body>""", file = opml_file)

for data_file in ["data.json"]:
    with open(data_file, 'r', encoding='utf8') as json_file:
        json_data = json.load(json_file)

    for index in range(len(json_data)):
        print("Checking:", json_data[index]["url"], end = " ")
        try:
            res = requests.get(json_data[index]["url"], timeout=5, headers=headers)
            if res.status_code == 200:
                json_data[index]["status"] = "OK"
                print("[ OK ]")
                if "feed" in json_data[index]:
                    if json_data[index]["feed"]:
                        try:
                            res = requests.get(json_data[index]["feed"], timeout=5, headers=headers)
                            if res.status_code == 200:
                                print(f'  <outline text="{json_data[index]["name"]}" type="rss" xmlUrl="{json_data[index]["feed"]}" htmlUrl="{json_data[index]["url"]}" description="{json_data[index]["sign"]}"/>', file = opml_file)
                        except:
                            pass
            else:
                json_data[index]["status"] = res.status_code
                print("[", res.status_code,"]")
        except Exception as e:
            json_data[index]["status"] = str(type(e)).split("'")[1].split(".")[2]
            print("[", json_data[index]["status"],"]")

    with open(data_file, 'w', encoding='utf8') as json_file:
        print("[", file = json_file)
        for index in range(len(json_data)):
            if index == len(json_data) - 1:
                print("  " + json.dumps(json_data[index], ensure_ascii=False), file = json_file)
            else:
                print("  " + json.dumps(json_data[index], ensure_ascii=False) + ",", file = json_file)
        print("]", file = json_file)
print("""</body>
</opml>""", file = opml_file)
opml_file.close()
