/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.agent.common.httpproxy.config;

import cloud.celonis.agent.common.httpproxy.config.ProxyConfiguration;
import cloud.celonis.agent.common.httpproxy.exception.InvalidProxyConfigFileException;
import cloud.celonis.commons.vault.Vault;
import cloud.celonis.commons.vault.VaultConfiguration;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpProxyConfigurationBase {
    private static final Logger log = LoggerFactory.getLogger(HttpProxyConfigurationBase.class);
    private final VaultConfiguration vaultConfiguration;

    public HttpProxyConfigurationBase(VaultConfiguration vaultConfiguration) {
        this.vaultConfiguration = vaultConfiguration;
    }

    protected abstract String getProxyConfigPath();

    public ProxyConfiguration loadProxyConfiguration() {
        if (StringUtils.isBlank((CharSequence)this.getProxyConfigPath())) {
            return null;
        }
        File proxyConfigFile = new File(this.getProxyConfigPath());
        if (!proxyConfigFile.exists()) {
            log.error("Proxy config not found: {}", (Object)this.getProxyConfigPath());
            System.exit(1);
        }
        try {
            ProxyConfiguration proxyConfiguration = (ProxyConfiguration)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue(proxyConfigFile, ProxyConfiguration.class);
            if (!proxyConfiguration.isEnabled()) {
                log.warn("Proxy is not enabled, requests will not go through the proxy.");
                return null;
            }
            if (proxyConfiguration.hasCredentials() && this.vaultConfiguration.isEnabled()) {
                proxyConfiguration.setPassword(Vault.decrypt((String)proxyConfiguration.getPassword(), (String)this.vaultConfiguration.getKey()));
            }
            return proxyConfiguration;
        }
        catch (IOException e) {
            throw new InvalidProxyConfigFileException(this.getProxyConfigPath(), e);
        }
    }
}

