/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.agent.common.httpproxy.service;

import cloud.celonis.agent.common.httpproxy.config.HttpProxyConfigurationBase;
import cloud.celonis.agent.common.httpproxy.config.ProxyConfiguration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;

public abstract class ProxyHttpRequestFactoryBase
extends HttpComponentsClientHttpRequestFactory {
    private static final Logger log = LoggerFactory.getLogger(ProxyHttpRequestFactoryBase.class);
    private final HttpProxyConfigurationBase httpProxyConfigurationBase;

    protected ProxyHttpRequestFactoryBase(HttpProxyConfigurationBase httpProxyConfigurationBase) {
        this.httpProxyConfigurationBase = httpProxyConfigurationBase;
        this.setHttpClientWithProxy();
    }

    private void setHttpClientWithProxy() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectionTimeout()).setSocketTimeout(this.getReadTimeout()).build();
        clientBuilder.disableCookieManagement().setDefaultRequestConfig(requestConfig);
        ProxyConfiguration proxyConfiguration = this.httpProxyConfigurationBase.loadProxyConfiguration();
        if (proxyConfiguration == null) {
            log.info("Proxy not configured, requests will not go through the proxy.");
            this.setHttpClient((HttpClient)clientBuilder.build());
            return;
        }
        HttpHost proxy = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort(), proxyConfiguration.getProtocol());
        clientBuilder.setProxy(proxy);
        if (proxyConfiguration.hasCredentials()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(proxyConfiguration.getHost(), proxyConfiguration.getPort()), (Credentials)new UsernamePasswordCredentials(proxyConfiguration.getUser(), proxyConfiguration.getPassword()));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        this.setHttpClient((HttpClient)clientBuilder.build());
    }

    public abstract int getConnectionTimeout();

    public abstract int getReadTimeout();
}

