/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.agent.common.loader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.stereotype.Component;

@Component
public class AgentLoaderProperties {
    private static final Logger log = LoggerFactory.getLogger(AgentLoaderProperties.class);
    private String jCoPath;
    @Deprecated
    private String connectorsPath;
    private String librariesPath;

    @PostConstruct
    public void init() throws IOException {
        Properties properties;
        File file = new File("loader.properties");
        if (file.exists()) {
            properties = new Properties();
            try (FileInputStream in = new FileInputStream(file);){
                properties.load(in);
            }
        } else {
            properties = PropertiesLoaderUtils.loadAllProperties((String)"loader.properties");
            PropertySourcesPlaceholderConfigurer propertiesConfigurer = new PropertySourcesPlaceholderConfigurer();
            propertiesConfigurer.setProperties(properties);
        }
        String[] paths = properties.getProperty("loader.path").split(",");
        this.jCoPath = paths[0];
        log.info("'jCoLoaderPath' is set to '{}'", (Object)this.jCoPath);
        if ("connectors".equals(paths[1])) {
            this.connectorsPath = paths[1];
            log.warn("Deprecated 'connectorsLoaderPath' is set to location '{}'. Please move the files from this directory to the new 'libraries' directory, in order to ensure future updates do not break anything", (Object)this.connectorsPath);
            if (paths.length < 3) {
                this.connectorsPath = paths[1];
                log.warn("No path for 'librariesLoaderPath' has been provided");
            } else if (paths.length == 3) {
                this.librariesPath = paths[2];
                log.info("'librariesLoaderPath' is set to '{}'", (Object)this.librariesPath);
            }
        } else {
            this.librariesPath = paths[1];
            log.info("'librariesLoaderPath' is set to '{}'", (Object)this.librariesPath);
        }
    }

    public String getJCoPath() {
        return this.jCoPath;
    }

    @Deprecated
    public String getConnectorsPath() {
        return this.connectorsPath;
    }

    public String getLibrariesPath() {
        return this.librariesPath;
    }
}

