/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.remotescript.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.remotescript.config.RemoteScriptConfig;
import cloud.celonis.remotescript.config.ScriptConfig;
import cloud.celonis.remotescript.model.RemoteScriptRequest;
import cloud.celonis.remotescript.model.ScriptResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service(value="remote-script")
@ConditionalOnProperty(prefix="connectors.remote-script", name={"enabled"}, havingValue="true")
public class RemoteScriptConnector
extends ConnectorBase<RemoteScriptRequest> {
    private static final Logger log = LoggerFactory.getLogger(RemoteScriptConnector.class);
    private final RemoteScriptConfig remoteScriptConfig;

    public RemoteScriptConnector(RemoteScriptConfig remoteScriptConfig) {
        this.remoteScriptConfig = remoteScriptConfig;
    }

    protected ScriptResponse execute(RemoteScriptRequest remoteScriptRequest) {
        try {
            Optional<ScriptConfig> optionalScriptConfig = this.remoteScriptConfig.getScriptConfigs().stream().filter(scriptElement -> remoteScriptRequest.getScriptName().equals(scriptElement.getName())).findFirst();
            if (!optionalScriptConfig.isPresent()) {
                return this.handleResponse("The specified script does not exist", -1);
            }
            ScriptConfig scriptConfig = optionalScriptConfig.get();
            StringBuilder sb = new StringBuilder();
            for (String arg : remoteScriptRequest.getArguments()) {
                sb.append("\"").append(arg).append("\"").append(" ");
            }
            String commandArguments = sb.toString();
            String fileFormat = FilenameUtils.getExtension((String)scriptConfig.getPath());
            Object command = this.getScriptCommand(fileFormat);
            command = (String)command + scriptConfig.getPath() + " " + commandArguments;
            Process processResponse = Runtime.getRuntime().exec((String)command);
            processResponse.waitFor();
            return this.handleResponse(IOUtils.toString((InputStream)processResponse.getInputStream(), (Charset)StandardCharsets.UTF_8), processResponse.exitValue());
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            return this.handleResponse(exception.getMessage(), -1);
        }
    }

    private ScriptResponse handleResponse(String body, Integer processCode) {
        ScriptResponse response = new ScriptResponse();
        response.setBody(body);
        response.setProcessCode(processCode);
        return response;
    }

    private String getScriptCommand(String fileFormat) {
        if (SystemUtils.IS_OS_WINDOWS && fileFormat.equals("exe")) {
            return "start ";
        }
        return "sh ";
    }
}

