/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.remotescript.validation;

import cloud.celonis.remotescript.validation.FileConstraint;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.SystemUtils;

public class FileValidator
implements ConstraintValidator<FileConstraint, String> {
    private static final List<String> WINDOWS_SUPPORTED_FILE_FORMATS = Arrays.asList("exe", "bat");
    private static final List<String> UNIX_SUPPORTED_FILE_FORMATS = Collections.singletonList("sh");

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value.isEmpty()) {
            return false;
        }
        File file = new File(value);
        if (!file.exists()) {
            return false;
        }
        String fileFormat = FilenameUtils.getExtension((String)value);
        if (SystemUtils.IS_OS_WINDOWS) {
            return WINDOWS_SUPPORTED_FILE_FORMATS.contains(fileFormat);
        }
        return UNIX_SUPPORTED_FILE_FORMATS.contains(fileFormat);
    }
}

