/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent;

import cloud.celonis.automation.agent.common.service.CloudConnectionService;
import cloud.celonis.automation.agent.common.service.celonis.CelonisCloudConnectionService;
import cloud.celonis.automation.agent.common.service.make.MakeCloudConnectionService;
import cloud.celonis.automation.agent.connect.service.AgentConnectionService;
import cloud.celonis.automation.agent.ping.service.PingService;
import cloud.celonis.automation.agent.register.service.AgentRegisterService;
import cloud.celonis.automation.agent.task.service.TaskDispatcher;
import javax.annotation.PreDestroy;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class AgentEngine
implements ApplicationRunner {
    private final CloudConnectionService cloudConnectionService;
    private final ApplicationContext applicationContext;
    private final TaskDispatcher taskDispatcher;
    private final PingService pingService;

    public AgentEngine(ApplicationContext applicationContext, TaskDispatcher taskDispatcher, PingService pingService, CloudConnectionService cloudConnectionService) {
        this.applicationContext = applicationContext;
        this.taskDispatcher = taskDispatcher;
        this.pingService = pingService;
        this.cloudConnectionService = cloudConnectionService;
    }

    public void run(ApplicationArguments args) {
        if (this.cloudConnectionService instanceof CelonisCloudConnectionService) {
            AgentRegisterService agentRegisterService = (AgentRegisterService)this.applicationContext.getBean("agentRegisterService", AgentRegisterService.class);
            agentRegisterService.register();
        } else {
            AgentConnectionService agentConnectionService = (AgentConnectionService)this.applicationContext.getBean("agentConnectionService", AgentConnectionService.class);
            agentConnectionService.connect();
        }
        this.taskDispatcher.start();
        this.pingService.start();
    }

    @PreDestroy
    public void stop() throws InterruptedException {
        this.taskDispatcher.stop();
        this.pingService.stop();
        if (this.cloudConnectionService instanceof MakeCloudConnectionService) {
            AgentConnectionService agentConnectionService = (AgentConnectionService)this.applicationContext.getBean("agentConnectionService", AgentConnectionService.class);
            agentConnectionService.disconnect();
        }
    }
}

