/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.connector.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.automation.agency.client.task.model.request.TaskRequest;
import cloud.celonis.automation.agent.common.connector.domain.Connector;
import cloud.celonis.automation.agent.common.connector.exception.ConnectorInvalidImplementationException;
import cloud.celonis.automation.agent.common.connector.exception.ConnectorNotSupportedException;
import cloud.celonis.automation.agent.common.secretProvider.service.SecretProviderService;
import cloud.celonis.automation.agent.config.ConnectorConfigurations;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ConnectorService {
    private static final Logger log = LoggerFactory.getLogger(ConnectorService.class);
    private final SecretProviderService secretProviderService;
    private final ConnectorConfigurations connectorConfigurations;
    private final ApplicationContext applicationContext;
    private final ObjectMapper agentObjectMapper;
    private final ExecutorService executor = Executors.newCachedThreadPool();

    public ConnectorService(SecretProviderService secretProviderService, ConnectorConfigurations connectorConfigurations, ApplicationContext applicationContext, ObjectMapper agentObjectMapper) {
        this.secretProviderService = secretProviderService;
        this.connectorConfigurations = connectorConfigurations;
        this.applicationContext = applicationContext;
        this.agentObjectMapper = agentObjectMapper;
    }

    public Future<Object> execute(TaskRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        Connector connectorConfig = (Connector)this.connectorConfigurations.getConnectors().get(request.getConnectorType());
        if (connectorConfig == null || !connectorConfig.isEnabled()) {
            throw new ConnectorNotSupportedException(String.format("Connector of type %s is not enabled on application.yml.", request.getConnectorType()));
        }
        try {
            ConnectorBase connector = (ConnectorBase)this.applicationContext.getBean(request.getConnectorType(), ConnectorBase.class);
            this.secretProviderService.execute(request.getBody(), connectorConfig.getSecretProviders());
            return this.executor.submit(() -> connector.apply(this.buildConvertedRequest(request.getBody(), connector)));
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new ConnectorNotSupportedException(String.format("Connector library of type %s is missing on the agent", request.getConnectorType()));
        }
        catch (BeansException be) {
            log.error("Something went wrong with the connector. Message: {}", (Object)be.getMessage());
            log.debug("Bean Exception details", (Throwable)be);
            throw new ConnectorInvalidImplementationException("Connector is in invalid state");
        }
    }

    @VisibleForTesting
    protected Object buildConvertedRequest(Object req, ConnectorBase connector) {
        if (req == null) {
            throw new IllegalArgumentException("Request body cannot be null");
        }
        if (connector == null) {
            throw new IllegalArgumentException("Connector cannot be null");
        }
        return this.agentObjectMapper.convertValue(req, this.getConnectorRequestClass(connector));
    }

    @VisibleForTesting
    protected Class getConnectorRequestClass(ConnectorBase connector) {
        if (connector == null) {
            throw new IllegalArgumentException("Connector cannot be null");
        }
        Type type = connector.getClass().getGenericSuperclass();
        Type type2 = ((Class)type).getGenericSuperclass();
        Type genericType = ((ParameterizedType)type2).getActualTypeArguments()[0];
        return (Class)genericType;
    }
}

