/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.secretProvider.config;

import cloud.celonis.automation.agent.common.secretProvider.exception.InvalidSecretProviderConfigFileException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SecretProviderConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(SecretProviderConfigLoader.class);
    private static final String ARG_SEPARATOR = "&";
    private static final String VALUES_SEPARATOR = "=";
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public Map<String, String> loadConfiguration(String secretProviderConfigPath) {
        if (secretProviderConfigPath == null) {
            log.info("Secret provider config file not provided");
            return new HashMap<String, String>();
        }
        File configFile = new File(secretProviderConfigPath);
        if (!configFile.exists()) {
            log.warn("Secret provider config not found: {}", (Object)secretProviderConfigPath);
            return new HashMap<String, String>();
        }
        try {
            return (Map)this.objectMapper.readValue(configFile, Map.class);
        }
        catch (IOException ex) {
            throw new InvalidSecretProviderConfigFileException(secretProviderConfigPath, (Throwable)ex);
        }
    }

    public Map<String, String> overrideProperties(String secretProviderRequest, Map<String, String> properties) {
        String[] requestProperties;
        HashMap<String, String> finalProperties = new HashMap<String, String>(properties);
        for (String requestProperty : requestProperties = secretProviderRequest.split(ARG_SEPARATOR)) {
            String[] propertyAndValue = requestProperty.split(VALUES_SEPARATOR);
            finalProperties.put(propertyAndValue[0], propertyAndValue[1]);
        }
        return finalProperties;
    }
}

