/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.secretProvider.service;

import cloud.celonis.automation.agent.common.connector.domain.Connector;
import cloud.celonis.automation.agent.common.secretProvider.config.SecretProviderConfigLoader;
import cloud.celonis.automation.agent.common.secretProvider.domain.SecretProvider;
import cloud.celonis.automation.agent.common.secretProvider.exception.EnforcedSecretProviderNotUsedException;
import cloud.celonis.automation.agent.config.ConnectorConfigurations;
import cloud.celonis.automation.agent.config.SecretProviderConfigurationsOnAgent;
import cloud.celonis.secret.resolver.domain.SecretResolverBase;
import cloud.celonis.secret.resolver.exception.base.SecretProviderNotSupportedException;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SecretProviderService {
    private static final Logger log = LoggerFactory.getLogger(SecretProviderService.class);
    private final Map<String, SecretResolverBase> secretResolvers;
    private final SecretProviderConfigLoader secretProviderConfigLoader;
    private final Map<String, Map<String, String>> secretProvidersConfigOnFiles;

    public SecretProviderService(Map<String, SecretResolverBase> secretResolvers, SecretProviderConfigurationsOnAgent secretProviderConfigurationsOnAgent, SecretProviderConfigLoader secretProviderConfigLoader, ConnectorConfigurations connectorsConfig) {
        this.secretResolvers = secretResolvers;
        this.secretProviderConfigLoader = secretProviderConfigLoader;
        SecretProviderService.addSecretProvidersAgentToConnectors((Map)connectorsConfig.getConnectors(), (Map)secretProviderConfigurationsOnAgent.getSecretProviders());
        this.secretProvidersConfigOnFiles = this.loadAllSecretProvidersConfigOnFiles(connectorsConfig.getConnectors());
    }

    public void execute(Object taskRequestBody, Map<String, SecretProvider> secretProvidersOnConnector) {
        if (taskRequestBody == null) {
            throw new IllegalArgumentException("Request cannot be null");
        }
        if (secretProvidersOnConnector == null) {
            throw new IllegalArgumentException("Secret providers cannot be null");
        }
        Map enforcedSecretProviders = SecretProviderService.getEnforcedSecretProvidersName(secretProvidersOnConnector);
        this.findAndResolveSecretProvidersProperties(taskRequestBody, secretProvidersOnConnector, enforcedSecretProviders);
        String notUsedEnforcedProviderName = SecretProviderService.getNotUsedEnforcedProviderName((Map)enforcedSecretProviders);
        if (notUsedEnforcedProviderName != null) {
            log.error("Enforced secret provider '{}' was not used in task request", (Object)notUsedEnforcedProviderName);
            throw new EnforcedSecretProviderNotUsedException(String.format("Enforced secret provider '%s was not used in task request", notUsedEnforcedProviderName));
        }
    }

    private Object findAndResolveSecretProvidersProperties(Object taskRequestBody, Map<String, SecretProvider> secretProviders, Map<String, Boolean> enforcedSecretProviders) {
        Map requestProperties = (Map)taskRequestBody;
        for (String propertyKey : requestProperties.keySet()) {
            Object propertyValue = requestProperties.get(propertyKey);
            if (propertyValue instanceof String) {
                String[] secretProviderTypeAndRequest = ((String)propertyValue).split("://", 2);
                if (!this.secretResolvers.containsKey(secretProviderTypeAndRequest[0])) continue;
                String resolvedProperty = this.resolveOneSecretProviderRequest(secretProviderTypeAndRequest[0], secretProviderTypeAndRequest[1], secretProviders);
                requestProperties.put(propertyKey, resolvedProperty);
                enforcedSecretProviders.put(secretProviderTypeAndRequest[0], true);
                continue;
            }
            if (!(propertyValue instanceof Map)) continue;
            requestProperties.put(propertyKey, this.findAndResolveSecretProvidersProperties(propertyValue, secretProviders, enforcedSecretProviders));
        }
        return requestProperties;
    }

    @VisibleForTesting
    protected String resolveOneSecretProviderRequest(String secretProviderType, String secretProviderRequest, Map<String, SecretProvider> secretProviders) {
        SecretProvider secretProviderConfig = secretProviders.get(secretProviderType);
        if (secretProviderConfig == null || !secretProviderConfig.isEnabled()) {
            log.error("Secret provider of type '{}' is not enabled on application.yml", (Object)secretProviderType);
            throw new SecretProviderNotSupportedException(String.format("Secret provider of type %s is not enabled on application.yml", secretProviderType));
        }
        SecretResolverBase secretResolver = (SecretResolverBase)this.secretResolvers.get(secretProviderType);
        if (secretResolver == null) {
            log.error("Library of '{}' secret resolver is missing on the agent", (Object)secretProviderType);
            throw new SecretProviderNotSupportedException(String.format("Library of '%s' secret resolver is missing on the agent", secretProviderType));
        }
        Map finalSecretProviderConfig = (Map)this.secretProvidersConfigOnFiles.get(secretProviderConfig.getConfigPath());
        finalSecretProviderConfig = this.secretProviderConfigLoader.overrideProperties(secretProviderRequest, finalSecretProviderConfig);
        return secretResolver.apply(finalSecretProviderConfig);
    }

    private static void addSecretProvidersAgentToConnectors(Map<String, Connector> connectors, Map<String, SecretProvider> secretProvidersOnAgent) {
        connectors.forEach((connectorName, connectorConfig) -> {
            if (connectorConfig.isEnabled()) {
                Map secretProvidersOnConnector = connectorConfig.getSecretProviders();
                secretProvidersOnAgent.forEach((secretProviderOnAgentName, secretProviderOnAgentConfig) -> {
                    if (secretProviderOnAgentConfig.isEnabled() && !secretProvidersOnConnector.containsKey(secretProviderOnAgentName)) {
                        secretProvidersOnConnector.put(secretProviderOnAgentName, secretProviderOnAgentConfig);
                    }
                });
            }
        });
    }

    private static Map<String, Boolean> getEnforcedSecretProvidersName(Map<String, SecretProvider> secretProviders) {
        HashMap<String, Boolean> enforcedSecretProviders = new HashMap<String, Boolean>();
        secretProviders.forEach((secretProviderName, secretProviderConfig) -> {
            if (secretProviderConfig.isEnabled() && secretProviderConfig.isEnforced()) {
                enforcedSecretProviders.put((String)secretProviderName, false);
            }
        });
        return enforcedSecretProviders;
    }

    private static String getNotUsedEnforcedProviderName(Map<String, Boolean> enforcedSecretProviders) {
        for (String secretProviderName : enforcedSecretProviders.keySet()) {
            boolean isUsed = enforcedSecretProviders.get(secretProviderName);
            if (isUsed) continue;
            return secretProviderName;
        }
        return null;
    }

    private Map<String, Map<String, String>> loadAllSecretProvidersConfigOnFiles(Map<String, Connector> connectors) {
        HashMap<String, Map<String, String>> secretProvidersConfigOnFiles = new HashMap<String, Map<String, String>>();
        connectors.forEach((connectorName, connectorConfig) -> {
            if (connectorConfig.isEnabled()) {
                connectorConfig.getSecretProviders().forEach((secretProviderName, secretProviderProperties) -> {
                    if (secretProviderProperties.isEnabled() && !secretProvidersConfigOnFiles.containsKey(secretProviderProperties.getConfigPath())) {
                        Map secretProviderConfig = this.secretProviderConfigLoader.loadConfiguration(secretProviderProperties.getConfigPath());
                        secretProvidersConfigOnFiles.put(secretProviderProperties.getConfigPath(), secretProviderConfig);
                    }
                });
            }
        });
        return secretProvidersConfigOnFiles;
    }
}

