/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.service.celonis;

import cloud.celonis.automation.agent.common.exception.RetryableException;
import cloud.celonis.automation.agent.common.service.CloudConnectionService;
import cloud.celonis.automation.agent.config.CelonisTeamConfiguration;
import cloud.celonis.automation.agent.httpproxy.service.ExternalProxyHttpRequestFactory;
import com.google.common.annotations.VisibleForTesting;
import java.net.SocketTimeoutException;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(prefix="celonis.authentication", name={"app-key"})
public class CelonisCloudConnectionService
extends CloudConnectionService {
    private static final Logger log = LoggerFactory.getLogger(CelonisCloudConnectionService.class);
    @VisibleForTesting
    protected static final String BROKER_BASE_URL = "/process-automation-broker/api/v2";
    private static final long DELAY_IN_MILLIS = 60000L;
    @VisibleForTesting
    protected RestTemplate restTemplate;
    private final CelonisTeamConfiguration celonisTeamConfiguration;

    public CelonisCloudConnectionService(ExternalProxyHttpRequestFactory externalProxyHttpRequestFactory, CelonisTeamConfiguration celonisTeamConfiguration) {
        this.celonisTeamConfiguration = celonisTeamConfiguration;
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)externalProxyHttpRequestFactory);
        this.restTemplate.getMessageConverters().removeIf(MappingJackson2XmlHttpMessageConverter.class::isInstance);
        this.restTemplate.getInterceptors().add((request, body, execution) -> {
            request.getHeaders().setContentType(MediaType.APPLICATION_JSON);
            request.getHeaders().set("Authorization", String.format("AppKey %s", celonisTeamConfiguration.getAppKey()));
            return execution.execute(request, body);
        });
    }

    public <T> T exchange(String path, HttpMethod method, Object body, ParameterizedTypeReference<T> responseType) {
        return (T)this.restTemplate.exchange(this.getCloudCelonisUrl(path), method, new HttpEntity(body), responseType, new Object[0]).getBody();
    }

    @Retryable(value={HttpServerErrorException.class, RetryableException.class}, maxAttempts=10, backoff=@Backoff(delay=60000L, maxDelay=9000000L, multiplier=2.0, random=true))
    public <T> T exchangeWithRetries(String path, HttpMethod method, Object body, ParameterizedTypeReference<T> responseType) {
        try {
            return (T)this.restTemplate.exchange(this.getCloudCelonisUrl(path), method, new HttpEntity(body), responseType, new Object[0]).getBody();
        }
        catch (Exception e) {
            log.warn("Request failed: {} '{}' - {}", new Object[]{method.name(), path, e.getMessage()});
            log.debug("Details: ", (Throwable)e);
            if (e.getCause() instanceof ConnectTimeoutException || e instanceof HttpStatusCodeException && ((HttpStatusCodeException)e).getStatusCode().equals((Object)HttpStatus.CONFLICT) || e.getCause() instanceof SocketTimeoutException && e.getMessage().contains("Read timed out")) {
                throw new RetryableException();
            }
            throw e;
        }
    }

    private String getCloudCelonisUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path of the request cannot be null");
        }
        return String.format("%s%s%s", this.celonisTeamConfiguration.getTeamUrl(), BROKER_BASE_URL, path);
    }
}

