/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.service.make;

import cloud.celonis.automation.agent.common.service.make.MakeCloudConnectionService;
import cloud.celonis.automation.agent.config.MakeConfiguration;
import cloud.celonis.automation.agent.connect.utils.AgentConnectionUtils;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class AgentAuthInterceptor
implements ClientHttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AgentAuthInterceptor.class);
    private final MakeCloudConnectionService cloudConnectionService;
    private final MakeConfiguration makeConfiguration;

    public AgentAuthInterceptor(MakeCloudConnectionService cloudConnectionService, MakeConfiguration makeConfiguration) {
        this.cloudConnectionService = cloudConnectionService;
        this.makeConfiguration = makeConfiguration;
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        if (this.cloudConnectionService.getIsRequestingToken().get() && !AgentConnectionUtils.isRequestATokenRequest((HttpRequest)request)) {
            log.debug("Delaying request {} because another thread is making the request for a new token", (Object)request.getURI());
            this.waitForToken();
        }
        HttpHeaders headers = request.getHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("x-celonis-team-id", this.makeConfiguration.getOrganizationId());
        String accessToken = this.cloudConnectionService.getAccessToken();
        if (accessToken == null && !AgentConnectionUtils.isRequestAConnectionRequest((HttpRequest)request)) {
            throw new RuntimeException("No token has provided for this request: " + request.getMethod() + " " + request.getURI());
        }
        if (accessToken != null) {
            headers.set("x-opa-auth", "Bearer " + accessToken);
        }
        return execution.execute(request, body);
    }

    public void waitForToken() {
        try {
            while (this.cloudConnectionService.getIsRequestingToken().get()) {
                log.debug("New token is still being requested");
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            log.error("New token wait state interrupted. {}", (Object)e.getMessage());
            log.debug("Details", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }
}

