/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.service.make;

import cloud.celonis.automation.agent.common.exception.RetryableException;
import cloud.celonis.automation.agent.common.service.CloudConnectionService;
import cloud.celonis.automation.agent.common.service.make.AgentAuthInterceptor;
import cloud.celonis.automation.agent.config.MakeConfiguration;
import cloud.celonis.automation.agent.connect.event.AgentEventPublisher;
import cloud.celonis.automation.agent.httpproxy.service.ExternalProxyHttpRequestFactory;
import com.google.common.annotations.VisibleForTesting;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.ConnectTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Retryable;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

@Service
@ConditionalOnProperty(prefix="make.authentication", name={"client-id", "client-secret"})
public class MakeCloudConnectionService
extends CloudConnectionService {
    private static final Logger log = LoggerFactory.getLogger(MakeCloudConnectionService.class);
    private final AtomicBoolean isRequestingToken = new AtomicBoolean();
    private String accessToken;
    @VisibleForTesting
    protected static final String BROKER_BASE_URL = "/process-automation-broker/api/v3";
    private static final long LONG_DELAY_IN_MILLIS = 60000L;
    private static final long SHORT_DELAY_IN_MILLIS = 500L;
    private final MakeConfiguration makeConfiguration;
    private final AgentEventPublisher eventPublisher;
    @VisibleForTesting
    protected RestTemplate restTemplate;

    public MakeCloudConnectionService(ExternalProxyHttpRequestFactory externalProxyHttpRequestFactory, MakeConfiguration makeConfiguration, AgentEventPublisher eventPublisher) {
        this.makeConfiguration = makeConfiguration;
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)externalProxyHttpRequestFactory);
        this.eventPublisher = eventPublisher;
        this.restTemplate.getMessageConverters().removeIf(MappingJackson2XmlHttpMessageConverter.class::isInstance);
        this.restTemplate.getInterceptors().add(new AgentAuthInterceptor(this, makeConfiguration));
    }

    public <T> T exchange(String path, HttpMethod method, Object body, ParameterizedTypeReference<T> responseType) {
        try {
            return (T)this.restTemplate.exchange(this.getUrl(path), method, new HttpEntity(body), responseType, new Object[0]).getBody();
        }
        catch (HttpClientErrorException.Unauthorized e) {
            this.requestNewToken();
            throw e;
        }
    }

    @Retryable(value={HttpServerErrorException.class, RetryableException.class}, maxAttempts=10, backoff=@Backoff(delay=60000L, maxDelay=9000000L, multiplier=2.0, random=true))
    public <T> T exchangeWithRetries(String path, HttpMethod method, Object body, ParameterizedTypeReference<T> responseType) {
        try {
            return (T)this.restTemplate.exchange(this.getUrl(path), method, new HttpEntity(body), responseType, new Object[0]).getBody();
        }
        catch (HttpClientErrorException.Unauthorized e) {
            this.requestNewToken();
            throw new RetryableException();
        }
        catch (Exception e) {
            log.warn("Request failed: {} '{}' - {}", new Object[]{method.name(), path, e.getMessage()});
            log.debug("Details: ", (Throwable)e);
            if (e.getCause() instanceof ConnectTimeoutException || e instanceof HttpStatusCodeException && ((HttpStatusCodeException)e).getStatusCode().equals((Object)HttpStatus.CONFLICT) || e.getCause() instanceof SocketTimeoutException && e.getMessage().contains("Read timed out")) {
                throw new RetryableException();
            }
            throw e;
        }
    }

    @Retryable(value={HttpServerErrorException.class, RetryableException.class}, maxAttempts=10, backoff=@Backoff(delay=500L))
    public String exchangeForTokenWithRetries(String path, HttpMethod method, Object body) {
        try {
            return (String)this.restTemplate.exchange(this.getUrl(path), method, new HttpEntity(body), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
        }
        catch (Exception e) {
            log.warn("Request failed: {} '{}' - {}", new Object[]{method.name(), this.getUrl(path), e.getMessage()});
            log.debug("Details: ", (Throwable)e);
            if (e.getCause() instanceof ConnectTimeoutException || e.getCause() instanceof SocketTimeoutException && e.getMessage().contains("Read timed out")) {
                throw new RetryableException();
            }
            throw e;
        }
    }

    private void requestNewToken() {
        if (this.isRequestingToken.compareAndSet(false, true)) {
            log.debug("Token has expired");
            this.eventPublisher.publishTokenRequestEvent();
        }
    }

    private String getUrl(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path of the request cannot be null");
        }
        if (StringUtils.isNotBlank((CharSequence)this.makeConfiguration.getBaseUrl())) {
            return String.format("%s%s%s", this.makeConfiguration.getBaseUrl(), BROKER_BASE_URL, path);
        }
        return String.format("%s%s%s", this.makeConfiguration.generateBaseUrl(), BROKER_BASE_URL, path);
    }

    public AtomicBoolean getIsRequestingToken() {
        return this.isRequestingToken;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }
}

