/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.common.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class AgentVersionUtil {
    private static final Logger log = LoggerFactory.getLogger(AgentVersionUtil.class);
    private static String version;

    public static String getVersion() {
        if (version != null) {
            return version;
        }
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources("classpath*:/version.txt");
            BufferedReader buf = new BufferedReader(new InputStreamReader(resources[0].getInputStream()));
            version = buf.lines().map(AgentVersionUtil::buildVersion).collect(Collectors.joining("/"));
            return version;
        }
        catch (Exception e) {
            log.warn("Agent version file can not be found");
            return null;
        }
    }

    private static String buildVersion(String property) {
        String element = property.substring(property.lastIndexOf(61) + 1);
        if (property.startsWith("version")) {
            return element.substring(0, 7);
        }
        return element;
    }
}

