/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.config;

import cloud.celonis.automation.agent.config.ConnectorConfigurations;
import cloud.celonis.automation.agent.config.SecretProviderConfigurationsOnAgent;
import cloud.celonis.commons.vault.VaultConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.validation.annotation.Validated;

@Validated
@EnableAsync
@Configuration
@ConfigurationProperties(prefix="agent")
public class AgentConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AgentConfiguration.class);
    private static final String DEFAULT_ID = "NONE";
    private String name;
    private String id;
    @Value(value="${agent.concurrent_executions}")
    private Integer concurrentExecutions = 100;
    private final BuildProperties buildProperties;
    private final ConnectorConfigurations connectorConfigurations;
    private final SecretProviderConfigurationsOnAgent secretProviderConfigurations;
    private final VaultConfiguration vaultConfiguration;

    public AgentConfiguration(BuildProperties buildProperties, ConnectorConfigurations connectorConfigurations, SecretProviderConfigurationsOnAgent secretProviderConfigurations, VaultConfiguration vaultConfiguration) {
        this.buildProperties = buildProperties;
        this.connectorConfigurations = connectorConfigurations;
        this.secretProviderConfigurations = secretProviderConfigurations;
        this.vaultConfiguration = vaultConfiguration;
    }

    public String getId() {
        return StringUtils.isNotBlank((CharSequence)this.id) ? this.id : DEFAULT_ID;
    }

    public int getConcurrentExecutions() {
        return this.concurrentExecutions;
    }

    public String getVersion() {
        return this.buildProperties.getVersion();
    }

    public String toString() {
        return StringUtils.isNotBlank((CharSequence)this.name) ? String.format("Configuration details - Agent name: %s, Agent id: %s, Agent concurrent executions limit: %s", this.getName(), this.getId(), this.getConcurrentExecutions()) : String.format("Configuration details - Agent ID: %s, Agent concurrent executions limit: %s", this.getId(), this.getConcurrentExecutions());
    }

    public String getName() {
        return this.name;
    }

    public BuildProperties getBuildProperties() {
        return this.buildProperties;
    }

    public VaultConfiguration getVaultConfiguration() {
        return this.vaultConfiguration;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setConcurrentExecutions(Integer concurrentExecutions) {
        this.concurrentExecutions = concurrentExecutions;
    }

    public ConnectorConfigurations getConnectorConfigurations() {
        return this.connectorConfigurations;
    }

    public SecretProviderConfigurationsOnAgent getSecretProviderConfigurations() {
        return this.secretProviderConfigurations;
    }
}

