/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.config;

import cloud.celonis.automation.agent.common.exception.AgentInstallerConfigException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentInstallerConfigMigrator {
    private static final Logger log = LoggerFactory.getLogger(AgentInstallerConfigMigrator.class);
    private static final XmlMapper XML_MAPPER = new XmlMapper();
    private static final ObjectMapper YML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String TEAM = "team";
    private static final String REALM = "realm";
    private static final String UPLINK = "uplink";
    private static final String APP_KEY = "appKey";
    private static final String AGENT_NAME = "agentName";
    private static final String AGENT = "agent";
    private static final String BASE_URL = "baseUrl";
    private static final String CLIENT_ID = "clientId";
    private static final String CLIENT_SECRET = "clientSecret";

    public static boolean tryToMigrate(String installerConfigFilePath, String appConfigFilePath) {
        if (installerConfigFilePath == null || appConfigFilePath == null) {
            return false;
        }
        log.info("Starting migration of installer to Agent configuration");
        File installerConfigFile = new File(installerConfigFilePath);
        if (!installerConfigFile.exists()) {
            log.info("'{}' not found, skipping migration", (Object)installerConfigFile.getName());
            return false;
        }
        File appConfigFile = new File(appConfigFilePath);
        if (!appConfigFile.exists()) {
            throw new AgentInstallerConfigException(String.format("Migration Failed! Configuration file '%s' not found", appConfigFile.getName()));
        }
        try {
            Map installerConfigMap = (Map)XML_MAPPER.readValue(installerConfigFile, Map.class);
            if (installerConfigMap.containsKey(UPLINK)) {
                String agentName;
                String appKey;
                String realm;
                Map installerConfig = (Map)installerConfigMap.get(UPLINK);
                String team = (String)installerConfig.get(TEAM);
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{team, realm = (String)installerConfig.get(REALM), appKey = (String)installerConfig.get(APP_KEY), agentName = (String)installerConfig.get(AGENT_NAME)})) {
                    log.info("One or more Uplink settings not configured in '{}', skipping migration", (Object)installerConfigFile.getName());
                    return false;
                }
                Map appConfigMap = (Map)YML_MAPPER.readValue(appConfigFile, Map.class);
                Map teamConfig = (Map)((Map)appConfigMap.get("celonis")).get("authentication");
                teamConfig.put("team-domain", team.trim());
                teamConfig.put("env", realm.trim());
                teamConfig.put("app-key", appKey.trim());
                Map agentConfig = (Map)appConfigMap.get(AGENT);
                agentConfig.put("name", agentName);
                YML_MAPPER.writeValue(appConfigFile, (Object)appConfigMap);
            } else if (installerConfigMap.containsKey(AGENT)) {
                String clientSecret;
                String clientId;
                Map installerConfig = (Map)installerConfigMap.get(AGENT);
                String baseUrl = (String)installerConfig.get(BASE_URL);
                if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{baseUrl, clientId = (String)installerConfig.get(CLIENT_ID), clientSecret = (String)installerConfig.get(CLIENT_SECRET)})) {
                    log.info("One or more Agent settings not configured in '{}', skipping migration", (Object)installerConfigFile.getName());
                    return false;
                }
                Map appConfigMap = (Map)YML_MAPPER.readValue(appConfigFile, Map.class);
                Map makeConfig = (Map)((Map)appConfigMap.get("make")).get("authentication");
                makeConfig.put("base-url", baseUrl.trim());
                makeConfig.put("client-id", clientId.trim());
                makeConfig.put("client-secret", clientSecret.trim());
                YML_MAPPER.writeValue(appConfigFile, (Object)appConfigMap);
            } else {
                return false;
            }
            if (installerConfigFile.delete()) {
                log.debug("'{}' was deleted successfully ", (Object)installerConfigFilePath);
            } else {
                log.debug("'{}' couldn't be deleted", (Object)installerConfigFilePath);
            }
            log.info("Finished migration of configuration");
            return true;
        }
        catch (IOException e) {
            throw new AgentInstallerConfigException("Migration failed", (Throwable)e);
        }
    }
}

