/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.config;

import javax.validation.constraints.NotEmpty;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.annotation.Validated;

@Configuration
@Validated
@ConfigurationProperties(prefix="celonis.authentication")
@ConditionalOnProperty(prefix="celonis.authentication", name={"app-key"})
public class CelonisTeamConfiguration {
    private String appKey;
    @NotEmpty
    private String teamDomain;
    @NotEmpty
    private String env;
    private String port;
    private String protocol;

    public String getTeamUrl() {
        Object teamUrl = String.format("%s://%s.%s.celonis.cloud", this.getProtocol(), this.getTeamDomain(), this.getEnv());
        if (StringUtils.isNotBlank((CharSequence)this.port)) {
            teamUrl = (String)teamUrl + String.format(":%s", this.port);
        }
        return teamUrl;
    }

    public String getProtocol() {
        return StringUtils.isBlank((CharSequence)this.protocol) ? "https" : this.protocol;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getTeamDomain() {
        return this.teamDomain;
    }

    public String getEnv() {
        return this.env;
    }

    public String getPort() {
        return this.port;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setTeamDomain(String teamDomain) {
        this.teamDomain = teamDomain;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

