/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.config;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationUpdater {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationUpdater.class);
    private static final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));

    public static void updateAgentId(String id) {
        String fileName = "application-local.yml";
        File file = new File(fileName);
        if (!file.exists()) {
            fileName = "application.yml";
            file = new File("./" + fileName);
        }
        try {
            JsonNode configuration = (JsonNode)objectMapper.readValue(file, JsonNode.class);
            if (configuration == null) {
                log.error("Failed to read and update {}. Please manually add/update agent.id: {}.", (Object)fileName, (Object)id);
                return;
            }
            JsonNode agentConfiguration = configuration.get("agent");
            if (agentConfiguration == null) {
                log.error("Agent configuration not found on {}. Please manually add/update agent.id: {}.", (Object)fileName, (Object)id);
            } else {
                ((ObjectNode)agentConfiguration).put("id", id);
                objectMapper.writeValue(file, (Object)configuration);
                log.info("Successfully updated agent.id on {}.", (Object)fileName);
            }
        }
        catch (Exception e) {
            log.error("Something went wrong while updating {}. Please manually add/update agent.id: {}", (Object)fileName, (Object)id);
        }
    }
}

