/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.config;

import cloud.celonis.commons.vault.Vault;
import cloud.celonis.commons.vault.VaultConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="make.authentication")
public class MakeConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MakeConfiguration.class);
    private String baseUrl;
    private String clientId;
    private String clientSecret;
    private String organizationId;
    private String env;
    private String port;
    private String protocol;

    public MakeConfiguration(VaultConfiguration vaultConfiguration) {
        if (vaultConfiguration.isEnabled()) {
            log.debug("Vault is enabled: decrypting client secret...");
            this.clientSecret = Vault.decrypt((String)this.clientSecret, (String)vaultConfiguration.getKey());
        }
    }

    public String generateBaseUrl() {
        Object teamUrl = String.format("%s://%s.make.com", this.getProtocol(), this.getEnv());
        if (StringUtils.isNotBlank((CharSequence)this.port)) {
            teamUrl = (String)teamUrl + String.format(":%s", this.port);
        }
        return teamUrl;
    }

    public String getProtocol() {
        return StringUtils.isBlank((CharSequence)this.protocol) ? "https" : this.protocol;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getOrganizationId() {
        return this.organizationId;
    }

    public String getEnv() {
        return this.env;
    }

    public String getPort() {
        return this.port;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setOrganizationId(String organizationId) {
        this.organizationId = organizationId;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

