/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.connect.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.automation.agency.client.agent.model.Agent;
import cloud.celonis.automation.agency.client.agent.model.AgentCredentials;
import cloud.celonis.automation.agent.common.service.make.MakeCloudConnectionService;
import cloud.celonis.automation.agent.config.AgentConfiguration;
import cloud.celonis.automation.agent.config.MakeConfiguration;
import cloud.celonis.automation.agent.connect.event.TokenRequestEvent;
import cloud.celonis.automation.agent.connect.exception.ResponseBodyNullException;
import cloud.celonis.automation.agent.connect.service.AgentRequestMapper;
import cloud.celonis.secret.resolver.domain.SecretResolverBase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.event.EventListener;
import org.springframework.http.HttpMethod;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
@ConditionalOnProperty(prefix="make.authentication", name={"client-id", "client-secret"})
public class AgentConnectionService {
    private static final Logger log = LoggerFactory.getLogger(AgentConnectionService.class);
    private final MakeConfiguration makeConfiguration;
    private final AgentConfiguration agentConfiguration;
    private final Map<String, ConnectorBase<?>> connectors;
    private final Map<String, SecretResolverBase> secretResolvers;
    private final MakeCloudConnectionService cloudConnectionService;

    public AgentConnectionService(MakeConfiguration makeConfiguration, MakeCloudConnectionService cloudConnectionService, AgentConfiguration agentConfiguration, Map<String, ConnectorBase<?>> connectors, Map<String, SecretResolverBase> secretResolvers) {
        this.makeConfiguration = makeConfiguration;
        this.cloudConnectionService = cloudConnectionService;
        this.agentConfiguration = agentConfiguration;
        this.connectors = connectors;
        this.secretResolvers = secretResolvers;
    }

    public void connect() {
        try {
            log.info("Trying to connect: awaiting for access token...");
            Agent agent = AgentRequestMapper.toAgent((String)this.makeConfiguration.getClientId(), (String)this.makeConfiguration.getClientSecret(), (AgentConfiguration)this.agentConfiguration, (Map)this.connectors, (Map)this.secretResolvers);
            String accessToken = this.cloudConnectionService.exchangeForTokenWithRetries("/agents/me/connect", HttpMethod.POST, (Object)agent);
            if (accessToken == null) {
                throw new ResponseBodyNullException("'Connect Agent' response is null.");
            }
            this.cloudConnectionService.setAccessToken(accessToken);
            log.info("Successfully connected Agent with ID {}", (Object)this.makeConfiguration.getClientId());
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.Unauthorized e) {
            log.error("Authorization exception. Please make sure you have entered a valid client ID and client secret");
            this.terminateProcess((Exception)e);
        }
        catch (Exception e) {
            this.terminateProcess(e);
        }
    }

    public void retrieveNewToken() {
        try {
            log.info("Sending a request for a new token");
            String accessToken = this.cloudConnectionService.exchangeForTokenWithRetries("/agents/me/token", HttpMethod.POST, (Object)new AgentCredentials(this.makeConfiguration.getClientId(), this.makeConfiguration.getClientSecret()));
            if (accessToken == null) {
                throw new ResponseBodyNullException("'Retrieve new token' response is null.");
            }
            this.cloudConnectionService.setAccessToken(accessToken);
            this.cloudConnectionService.getIsRequestingToken().set(false);
            log.info("Successfully retrieved new token");
        }
        catch (HttpClientErrorException.Forbidden | HttpClientErrorException.Unauthorized e) {
            log.error("Authorization exception. Please make sure you have entered a valid client ID and client secret");
            this.terminateProcess((Exception)e);
        }
        catch (Exception e) {
            this.terminateProcess(e);
        }
    }

    @Async
    @EventListener
    public void onTokenRequest(TokenRequestEvent e) {
        log.debug("Received a TokenRequestEvent. Trying to connect again...");
        this.retrieveNewToken();
    }

    private void terminateProcess(Exception e) {
        log.error("Failed to connect agent. Terminating process.", (Throwable)e);
        System.exit(1);
    }

    public void disconnect() {
        log.debug("Sending stop signal to Agency...");
        this.cloudConnectionService.exchange("/agents/me/stop", HttpMethod.POST, null);
    }
}

