/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.connect.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.automation.agency.client.agent.connector.model.AgencyConnector;
import cloud.celonis.automation.agency.client.agent.model.Agent;
import cloud.celonis.automation.agent.common.connector.domain.Connector;
import cloud.celonis.automation.agent.common.secretProvider.domain.SecretProvider;
import cloud.celonis.automation.agent.config.AgentConfiguration;
import cloud.celonis.secret.resolver.domain.SecretResolverBase;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgentRequestMapper {
    private static final Logger log = LoggerFactory.getLogger(AgentRequestMapper.class);

    private AgentRequestMapper() {
    }

    public static Agent toAgent(AgentConfiguration agentConfiguration, Map<String, ConnectorBase<?>> connectorBeans, Map<String, SecretResolverBase> secretResolverBeans) {
        Map agentSecretProviders = agentConfiguration.getSecretProviderConfigurations().getSecretProviders();
        Map connectorConfigurations = agentConfiguration.getConnectorConfigurations().getConnectors();
        Agent agent = new Agent();
        agent.setId(agentConfiguration.getId());
        agent.setName(agentConfiguration.getName());
        agent.setVersion(agentConfiguration.getVersion());
        agent.setConnectors(connectorConfigurations.entrySet().stream().map(connectorEntry -> {
            Map secretProviderConfigs;
            String connectorType = (String)connectorEntry.getKey();
            Connector connectorConfig = (Connector)connectorEntry.getValue();
            AgencyConnector connector = new AgencyConnector();
            connector.setType(connectorType);
            connector.setEnabled(connectorConfig.isEnabled());
            if (connectorBeans.containsKey(connectorType)) {
                connector.setPresent(true);
                connector.setVersion(AgentRequestMapper.findConnectorVersion((String)connectorType));
            }
            if (!(secretProviderConfigs = AgentRequestMapper.getSecretProviderConfigs((Map)agentSecretProviders, (Map)connectorConfig.getSecretProviders(), (Map)secretResolverBeans)).isEmpty()) {
                connector.setConfiguration(Map.of("secretProviders", secretProviderConfigs));
            }
            return connector;
        }).collect(Collectors.toList()));
        return agent;
    }

    public static Agent toAgent(String clientId, String clientSecret, AgentConfiguration agentConfiguration, Map<String, ConnectorBase<?>> connectorBeans, Map<String, SecretResolverBase> secretResolverBeans) {
        Agent agent = AgentRequestMapper.toAgent((AgentConfiguration)agentConfiguration, connectorBeans, secretResolverBeans);
        agent.setId(clientId);
        agent.setClientSecret(clientSecret);
        return agent;
    }

    private static Map<String, Map<String, Boolean>> getSecretProviderConfigs(Map<String, SecretProvider> agentSecretProviderMap, Map<String, SecretProvider> connectorSecretProviderMap, Map<String, SecretResolverBase> secretResolverBeans) {
        HashMap<String, Map<String, Boolean>> secretProviderConfiguration = new HashMap<String, Map<String, Boolean>>();
        agentSecretProviderMap.forEach((secretProviderName, secretProviderConfig) -> secretProviderConfiguration.put((String)secretProviderName, Map.of("enabled", secretProviderConfig.isEnabled(), "enforced", secretProviderConfig.isEnforced(), "fullySetup", secretResolverBeans.containsKey(secretProviderName) && ((SecretResolverBase)secretResolverBeans.get(secretProviderName)).isFullyConfigured())));
        connectorSecretProviderMap.forEach((secretProviderName, secretProviderConfig) -> secretProviderConfiguration.put((String)secretProviderName, Map.of("enabled", secretProviderConfig.isEnabled(), "enforced", secretProviderConfig.isEnforced(), "fullySetup", secretResolverBeans.containsKey(secretProviderName) && ((SecretResolverBase)secretResolverBeans.get(secretProviderName)).isFullyConfigured())));
        return secretProviderConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String findConnectorVersion(String connectorType) {
        ClassLoader loader = ClassUtils.getDefaultClassLoader();
        if (loader == null) return null;
        try {
            URL url;
            String fileName;
            Enumeration<URL> urls = loader.getResources("META-INF/build-info.properties");
            do {
                if (!urls.hasMoreElements()) return null;
            } while (!(fileName = (url = urls.nextElement()).getFile()).contains(connectorType));
            Properties connectorBuildProperties = new Properties();
            URLConnection con = url.openConnection();
            try (InputStream is = con.getInputStream();){
                connectorBuildProperties.load(is);
                String string = connectorBuildProperties.getProperty("build.version");
                return string;
            }
        }
        catch (Exception e) {
            log.warn("Something went wrong while finding version for {} connector. Message: {}", (Object)connectorType, (Object)e.getMessage());
            log.debug("Details", (Throwable)e);
        }
        return null;
    }
}

