/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CachedLogs {
    private static final ConcurrentLinkedQueue<ILoggingEvent> logsQueue = new ConcurrentLinkedQueue();

    private CachedLogs() {
    }

    public static void add(ILoggingEvent log) {
        if (log == null) {
            return;
        }
        logsQueue.add(log);
    }

    public static void addAll(List<ILoggingEvent> logs) {
        if (logs == null) {
            return;
        }
        logsQueue.addAll(logs);
    }

    public static List<ILoggingEvent> getAndClearLogs() {
        ArrayList<ILoggingEvent> logsList = new ArrayList<ILoggingEvent>();
        int queueSize = logsQueue.size();
        for (int i = 0; i < queueSize; ++i) {
            logsList.add((ILoggingEvent)logsQueue.poll());
        }
        return logsList;
    }

    @VisibleForTesting
    protected static ConcurrentLinkedQueue<ILoggingEvent> getLogsQueue() {
        return logsQueue;
    }
}

