/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.ping.service;

import cloud.celonis.automation.agency.client.agent.model.AgentStatus;
import cloud.celonis.automation.agent.common.service.CloudConnectionService;
import cloud.celonis.automation.agent.common.service.celonis.CelonisCloudConnectionService;
import cloud.celonis.automation.agent.config.AgentConfiguration;
import cloud.celonis.automation.agent.logging.CachedLogs;
import cloud.celonis.automation.agent.logging.LoggingEventMapper;
import cloud.celonis.automation.agent.task.domain.RunningTasksStorage;
import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;

@Service
public class PingService {
    private static final Logger log = LoggerFactory.getLogger(PingService.class);
    @VisibleForTesting
    protected static final String AGENT_UPDATED_SUCCESSFULLY_MESSAGE = "Successfully updated agent status.";
    private static final long PING_SERVICE_INTERVAL_IN_SECONDS = 10L;
    private final AgentConfiguration agentConfiguration;
    private final CloudConnectionService cloudConnectionService;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private boolean encounteredError = false;

    public PingService(AgentConfiguration agentConfiguration, CloudConnectionService cloudConnectionService) {
        this.agentConfiguration = agentConfiguration;
        this.cloudConnectionService = cloudConnectionService;
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> this.ping(), 0L, 10L, TimeUnit.SECONDS);
    }

    @VisibleForTesting
    protected void ping() {
        List pendingLogs = null;
        try {
            pendingLogs = CachedLogs.getAndClearLogs();
            AgentStatus agentStatus = this.getAgentStatus();
            agentStatus.setLogs(LoggingEventMapper.toLoggingEventList((List)pendingLogs));
            log.debug("Updating agent status...");
            if (this.cloudConnectionService instanceof CelonisCloudConnectionService) {
                this.cloudConnectionService.exchange(String.format("/agents/%s/keep-alive", this.agentConfiguration.getId()), HttpMethod.POST, (Object)agentStatus);
            } else {
                this.cloudConnectionService.exchange("/agents/me/keep-alive", HttpMethod.POST, (Object)agentStatus);
            }
            if (this.encounteredError) {
                log.info(AGENT_UPDATED_SUCCESSFULLY_MESSAGE);
                this.encounteredError = false;
            } else {
                log.debug(AGENT_UPDATED_SUCCESSFULLY_MESSAGE);
            }
        }
        catch (Throwable t) {
            CachedLogs.addAll((List)pendingLogs);
            log.error("Error while trying to update agent status: {}", (Object)t.getMessage());
            log.debug("Details: ", t);
            this.encounteredError = true;
        }
    }

    private AgentStatus getAgentStatus() {
        AgentStatus agentStatus = new AgentStatus();
        agentStatus.setRunningTaskIds(RunningTasksStorage.getTaskIds());
        agentStatus.setMemoryHeapUsed((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
        agentStatus.setMemoryHeapTotal((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        return agentStatus;
    }

    public void stop() throws InterruptedException {
        log.info("Gracefully shutting down scheduler for updating Agent Status. Please wait...");
        this.scheduledExecutorService.shutdown();
        if (!this.scheduledExecutorService.awaitTermination(5L, TimeUnit.SECONDS)) {
            log.info("Couldn't await termination of the scheduler for updating Agent Status.");
            return;
        }
        log.info("Successfully shut down scheduler for updating Agent Status");
    }

    @VisibleForTesting
    protected boolean getEncounteredError() {
        return this.encounteredError;
    }

    @VisibleForTesting
    protected void setEncounteredError(boolean encounteredError) {
        this.encounteredError = encounteredError;
    }
}

