/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.register.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.automation.agency.client.agent.model.Agent;
import cloud.celonis.automation.agent.common.service.celonis.CelonisCloudConnectionService;
import cloud.celonis.automation.agent.config.AgentConfiguration;
import cloud.celonis.automation.agent.config.ConfigurationUpdater;
import cloud.celonis.automation.agent.connect.service.AgentRequestMapper;
import cloud.celonis.automation.agent.register.exception.ResponseBodyNullException;
import cloud.celonis.secret.resolver.domain.SecretResolverBase;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
@ConditionalOnProperty(prefix="celonis.authentication", name={"app-key"})
public class AgentRegisterService {
    private static final Logger log = LoggerFactory.getLogger(AgentRegisterService.class);
    private final AgentConfiguration agentConfiguration;
    private final Map<String, ConnectorBase<?>> connectorBeans;
    private final CelonisCloudConnectionService cloudConnectionService;
    private final Map<String, SecretResolverBase> secretResolverBeans;

    public AgentRegisterService(AgentConfiguration agentConfiguration, Map<String, ConnectorBase<?>> connectorBeans, CelonisCloudConnectionService cloudConnectionService, Map<String, SecretResolverBase> secretResolverBeans) {
        this.connectorBeans = connectorBeans;
        this.agentConfiguration = agentConfiguration;
        this.secretResolverBeans = secretResolverBeans;
        this.cloudConnectionService = cloudConnectionService;
    }

    public void register() {
        log.info("Registering agent. {}", (Object)this.agentConfiguration.toString());
        try {
            Agent agent = this.registerAgent();
            log.info("Successfully registered agent with id: {}, name: {} and version: {}", new Object[]{agent.getId(), agent.getName(), agent.getVersion()});
            if (!this.agentConfiguration.getId().equals(agent.getId())) {
                ConfigurationUpdater.updateAgentId((String)agent.getId());
                this.agentConfiguration.setId(agent.getId());
            }
        }
        catch (Exception e) {
            this.terminateProcess(e);
        }
    }

    private Agent registerAgent() {
        Agent agent = null;
        try {
            agent = (Agent)this.cloudConnectionService.exchangeWithRetries("/agents", HttpMethod.POST, (Object)AgentRequestMapper.toAgent((AgentConfiguration)this.agentConfiguration, (Map)this.connectorBeans, (Map)this.secretResolverBeans), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (HttpClientErrorException e) {
            if (e.getStatusCode() == HttpStatus.FORBIDDEN || e.getStatusCode() == HttpStatus.UNAUTHORIZED) {
                log.error("Authorization exception. Please make sure you have entered a valid AppKey");
            }
            this.terminateProcess((Exception)((Object)e));
        }
        catch (Exception e) {
            this.terminateProcess(e);
        }
        if (agent == null) {
            this.terminateProcess((Exception)new ResponseBodyNullException("'Register Agent' response is null."));
        }
        return agent;
    }

    private void terminateProcess(Exception e) {
        log.error("Failed to register agent. Terminating process.", (Throwable)e);
        System.exit(1);
    }
}

