/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.task.domain;

import cloud.celonis.agent.common.connector.model.error.ValidationErrorResponse;
import cloud.celonis.automation.agency.client.task.model.request.TaskRequestWrapper;
import cloud.celonis.automation.agency.client.task.model.response.TaskResponse;
import cloud.celonis.automation.agency.client.task.model.response.TaskResponseCode;
import cloud.celonis.automation.agency.client.task.model.response.TaskResponseWrapper;
import cloud.celonis.automation.agent.common.connector.exception.ConnectorNotSupportedException;
import cloud.celonis.automation.agent.common.connector.service.ConnectorService;
import cloud.celonis.automation.agent.common.service.CloudConnectionService;
import cloud.celonis.automation.agent.common.service.celonis.CelonisCloudConnectionService;
import cloud.celonis.automation.agent.config.AgentConfiguration;
import cloud.celonis.automation.agent.task.domain.RunningTasksStorage;
import cloud.celonis.secret.resolver.exception.base.SecretProviderNotSupportedException;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.naming.directory.InvalidAttributesException;
import javax.validation.ConstraintViolationException;
import org.hibernate.validator.internal.engine.path.PathImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;

public class TaskExecution
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TaskExecution.class);
    @VisibleForTesting
    protected static final String CONSTRAINT_VIOLATION_PREFIX = "{javax.validation";
    private static final String TASK_REQUEST_NULL_MESSAGE = "Task Request cannot be null";
    private final CloudConnectionService cloudConnectionService;
    private final ConnectorService connectorService;
    private final TaskRequestWrapper taskRequestWrapper;
    private final AgentConfiguration agent;

    public TaskExecution(CloudConnectionService cloudConnectionService, ConnectorService connectorService, TaskRequestWrapper taskRequestWrapper, AgentConfiguration agent) {
        this.cloudConnectionService = cloudConnectionService;
        this.connectorService = connectorService;
        this.taskRequestWrapper = taskRequestWrapper;
        this.agent = agent;
    }

    @Override
    public void run() {
        TaskResponseWrapper taskResponse;
        block12: {
            taskResponse = this.buildTaskResponse();
            if (this.taskRequestWrapper.getRequest() == null) {
                log.error(TASK_REQUEST_NULL_MESSAGE);
                taskResponse.getResponse().setBody((Object)TASK_REQUEST_NULL_MESSAGE);
                taskResponse.getResponse().setCode(TaskResponseCode.CLIENT_ERROR);
                this.sendTaskResponse(taskResponse);
                return;
            }
            taskResponse.getResponse().setRequesterId(this.taskRequestWrapper.getRequest().getRequesterId());
            taskResponse.getResponse().setConnectorType(this.taskRequestWrapper.getRequest().getConnectorType());
            try {
                this.validateTaskRequest();
            }
            catch (InvalidAttributesException e) {
                log.error(e.getMessage());
                taskResponse.getResponse().setBody((Object)e);
                taskResponse.getResponse().setCode(TaskResponseCode.CLIENT_ERROR);
                this.sendTaskResponse(taskResponse);
                return;
            }
            log.info("Successfully pulled task with ID: {}", (Object)this.taskRequestWrapper.getId());
            RunningTasksStorage.add((String)this.taskRequestWrapper.getId());
            Future connectorResultFuture = null;
            try {
                connectorResultFuture = this.connectorService.execute(this.taskRequestWrapper.getRequest());
            }
            catch (ConnectorNotSupportedException | SecretProviderNotSupportedException e) {
                log.error("Execution of task type {} with id {} failed: {}", new Object[]{this.taskRequestWrapper.getRequest().getConnectorType(), this.taskRequestWrapper.getId(), e.getMessage()});
                taskResponse.getResponse().setBody((Object)e);
                taskResponse.getResponse().setCode(TaskResponseCode.CLIENT_ERROR);
            }
            catch (Exception e) {
                log.error("Something went wrong while executing task of type {} with id {}", new Object[]{this.taskRequestWrapper.getRequest().getConnectorType(), this.taskRequestWrapper.getId(), e});
                taskResponse.getResponse().setBody((Object)e);
                taskResponse.getResponse().setCode(TaskResponseCode.SERVER_ERROR);
            }
            if (connectorResultFuture != null) {
                try {
                    taskResponse.getResponse().setBody(connectorResultFuture.get(this.taskRequestWrapper.getRequest().getExpiresAfterInMillis(), TimeUnit.MILLISECONDS));
                    taskResponse.getResponse().setCode(TaskResponseCode.SUCCESSFUL);
                    log.info("Successfully finished task {} ", (Object)this.taskRequestWrapper.getId());
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ConstraintViolationException) {
                        log.error("Validation error when executing task of type {} with id {}; {}", new Object[]{this.taskRequestWrapper.getRequest().getConnectorType(), this.taskRequestWrapper.getId(), e.getMessage()});
                        taskResponse.getResponse().setBody((Object)this.extractValidationErrorResponse((ConstraintViolationException)e.getCause()));
                        taskResponse.getResponse().setCode(TaskResponseCode.VALIDATION_ERROR);
                    } else {
                        log.error("Something went wrong while executing task of type {} with id {}; {}", new Object[]{this.taskRequestWrapper.getRequest().getConnectorType(), this.taskRequestWrapper.getId(), e.getMessage()});
                        log.debug("Exception Details", (Throwable)e);
                        taskResponse.getResponse().setBody((Object)e);
                        taskResponse.getResponse().setCode(TaskResponseCode.SERVER_ERROR);
                    }
                }
                catch (InterruptedException | TimeoutException te) {
                    log.warn("Execution of task type {} with id {} timed out after {} ms", new Object[]{this.taskRequestWrapper.getRequest().getConnectorType(), this.taskRequestWrapper.getId(), this.taskRequestWrapper.getRequest().getExpiresAfterInMillis()});
                    taskResponse.getResponse().setCode(TaskResponseCode.MESSAGE_EXPIRED);
                    if (!(te instanceof InterruptedException)) break block12;
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.sendTaskResponse(taskResponse);
        RunningTasksStorage.remove((String)this.taskRequestWrapper.getId());
    }

    private TaskResponseWrapper buildTaskResponse() {
        TaskResponseWrapper taskResponse = new TaskResponseWrapper();
        taskResponse.setAgentId(this.agent.getId());
        taskResponse.setAgentName(this.agent.getName());
        taskResponse.setAgentVersion(this.agent.getVersion());
        taskResponse.setRequestId(this.taskRequestWrapper.getId());
        taskResponse.setReplyTo(this.taskRequestWrapper.getReplyTo());
        taskResponse.setCorrelationId(this.taskRequestWrapper.getCorrelationId());
        TaskResponse response = new TaskResponse();
        response.setAgentId(this.agent.getId());
        response.setStartDate(this.taskRequestWrapper.getCreatedDate());
        response.setFinishDate(new Date());
        taskResponse.setResponse(response);
        return taskResponse;
    }

    private void validateTaskRequest() throws InvalidAttributesException {
        if (this.taskRequestWrapper.getRequest().getConnectorType() == null) {
            throw new InvalidAttributesException(String.format("Task connectorType is missing for task with id %s.", this.taskRequestWrapper.getId()));
        }
    }

    private void sendTaskResponse(TaskResponseWrapper taskResponse) {
        try {
            if (this.cloudConnectionService instanceof CelonisCloudConnectionService) {
                this.cloudConnectionService.exchangeWithRetries(String.format("/agents/%s/tasks/%s", this.agent.getName(), this.taskRequestWrapper.getId()), HttpMethod.POST, (Object)taskResponse, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                this.cloudConnectionService.exchangeWithRetries(String.format("/agents/me/tasks/%s", this.taskRequestWrapper.getId()), HttpMethod.POST, (Object)taskResponse, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            log.info("Successfully sent response back to broker for task with ID: {}", (Object)this.taskRequestWrapper.getId());
        }
        catch (Exception e) {
            log.error("Failed to send response back to broker for task with ID: {}", (Object)this.taskRequestWrapper.getId(), (Object)e);
        }
    }

    private List<ValidationErrorResponse> extractValidationErrorResponse(ConstraintViolationException e) {
        if (e.getConstraintViolations() != null) {
            return e.getConstraintViolations().stream().map(constraintViolation -> {
                String attributeName = ((PathImpl)constraintViolation.getPropertyPath()).getLeafNode().getName();
                ValidationErrorResponse errorResponse = new ValidationErrorResponse(attributeName);
                if (constraintViolation.getMessageTemplate().startsWith(CONSTRAINT_VIOLATION_PREFIX)) {
                    errorResponse.setMessage(attributeName + " " + constraintViolation.getMessage());
                } else {
                    errorResponse.setMessage(constraintViolation.getMessageTemplate());
                }
                return errorResponse;
            }).collect(Collectors.toList());
        }
        log.warn("There are no constraint violations", (Throwable)e);
        ArrayList<ValidationErrorResponse> validationErrorResponseList = new ArrayList<ValidationErrorResponse>();
        ValidationErrorResponse validationErrorResponse = new ValidationErrorResponse(null);
        validationErrorResponse.setMessage(e.getMessage());
        validationErrorResponseList.add(validationErrorResponse);
        return validationErrorResponseList;
    }
}

