/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.automation.agent.task.service;

import cloud.celonis.automation.agency.client.task.model.query.TaskQuery;
import cloud.celonis.automation.agency.client.task.model.request.TaskRequestWrapper;
import cloud.celonis.automation.agent.common.connector.service.ConnectorService;
import cloud.celonis.automation.agent.common.service.CloudConnectionService;
import cloud.celonis.automation.agent.common.service.celonis.CelonisCloudConnectionService;
import cloud.celonis.automation.agent.config.AgentConfiguration;
import cloud.celonis.automation.agent.task.domain.TaskExecution;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;

@Service
public class TaskDispatcher {
    private static final Logger log = LoggerFactory.getLogger(TaskDispatcher.class);
    private final CloudConnectionService cloudConnectionService;
    private final ConnectorService connectorService;
    private final AgentConfiguration agentConfiguration;
    private final ExecutorService pollExecutor = Executors.newSingleThreadExecutor();
    private final ThreadPoolExecutor taskExecutor;
    private boolean encounteredError = false;

    public TaskDispatcher(CloudConnectionService cloudConnectionService, ConnectorService connectorService, AgentConfiguration agentConfiguration) {
        this.cloudConnectionService = cloudConnectionService;
        this.connectorService = connectorService;
        this.agentConfiguration = agentConfiguration;
        this.taskExecutor = new ThreadPoolExecutor(0, agentConfiguration.getConcurrentExecutions(), 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    public void start() {
        this.pollExecutor.execute(() -> this.pollAndExecuteTasks());
    }

    private void pollAndExecuteTasks() {
        log.info("Started to poll for tasks.");
        while (!this.pollExecutor.isShutdown()) {
            if (this.taskExecutor.getActiveCount() < this.agentConfiguration.getConcurrentExecutions()) {
                log.debug("Requesting new tasks...");
                List taskRequests = this.getTasks();
                log.debug("Number of tasks received: {}", (Object)taskRequests.size());
                if (taskRequests.isEmpty()) continue;
                taskRequests.forEach(taskRequest -> {
                    if (taskRequest == null) {
                        log.error("Task Request cannot be null");
                    } else {
                        try {
                            this.taskExecutor.execute((Runnable)new TaskExecution(this.cloudConnectionService, this.connectorService, taskRequest, this.agentConfiguration));
                        }
                        catch (Exception e) {
                            log.error("Failed to start execution of task with id: {}", (Object)taskRequest.getId(), (Object)e);
                        }
                    }
                });
                continue;
            }
            log.info("Concurrent executions limit: {} has been reached, number of current running tasks: {}", (Object)this.agentConfiguration.getConcurrentExecutions(), (Object)this.taskExecutor.getActiveCount());
        }
    }

    protected List<TaskRequestWrapper> getTasks() {
        TaskQuery taskQuery = new TaskQuery();
        taskQuery.setAgentName(this.agentConfiguration.getName());
        taskQuery.setAgentVersion(this.agentConfiguration.getVersion());
        taskQuery.setConsumeLimit(this.agentConfiguration.getConcurrentExecutions() - this.taskExecutor.getActiveCount());
        List taskRequests = null;
        try {
            taskRequests = this.cloudConnectionService instanceof CelonisCloudConnectionService ? (List)this.cloudConnectionService.exchange(String.format("/agents/%s/tasks", this.agentConfiguration.getName()), HttpMethod.POST, (Object)taskQuery, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */) : (List)this.cloudConnectionService.exchange("/agents/me/tasks", HttpMethod.POST, (Object)taskQuery, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (this.encounteredError) {
                log.info("Successfully polled for new tasks.");
                this.encounteredError = false;
            }
        }
        catch (HttpClientErrorException.NotFound nfe) {
            log.error("The agent doesn't exist anymore. Shutting down the agent");
            System.exit(1);
        }
        catch (Exception e) {
            log.error("Failed to get new tasks. {}", (Object)e.getMessage());
            log.debug("Details: ", (Throwable)e);
            this.encounteredError = true;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                log.debug("Stand-by interrupted.", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        if (taskRequests == null) {
            log.debug("Request for getting tasks returned a null response.");
            return Collections.emptyList();
        }
        return taskRequests;
    }

    public void stop() throws InterruptedException {
        boolean tasksCompleted;
        log.info("Gracefully shutting down the agent. Please wait...");
        this.pollExecutor.shutdown();
        if (!this.pollExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
            log.info("Couldn't await termination of pollExecutor. {}", this.taskExecutor.getQueue());
            return;
        }
        this.taskExecutor.shutdown();
        log.info("Waiting for the service to terminate...");
        try {
            tasksCompleted = this.taskExecutor.awaitTermination(301000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            tasksCompleted = false;
            Thread.currentThread().interrupt();
        }
        if (!tasksCompleted) {
            log.info("Couldn't await termination of all queued tasks. {}", this.taskExecutor.getQueue());
            Thread.currentThread().interrupt();
        } else {
            log.info("Successfully waited for all tasks to be completed");
        }
    }
}

