/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.cyberark.service;

import cloud.celonis.cyberark.service.CyberarkSecretResolverExecutor;
import cloud.celonis.secret.resolver.domain.SecretResolverBase;
import cloud.celonis.secret.resolver.exception.SecretProviderJarFileNotFound;
import cloud.celonis.secret.resolver.system.SecretProviderJarLoader;
import cloud.celonis.secret.resolver.system.SecretProviderLoaderProperties;
import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service(value="cyberark")
public class CyberarkSecretResolver
extends SecretResolverBase {
    @VisibleForTesting
    protected static String cyberarkClassProbe = "javapasswordsdk.PSDKPasswordRequest";
    private static String cyberarkJarName = "javapasswordsdk.jar";
    private static String cyberarkName = "Cyberark";
    @VisibleForTesting
    protected SecretProviderJarLoader cyberarkJarLoader;
    @VisibleForTesting
    protected CyberarkSecretResolverExecutor cyberarkSecretResolverExecutor;

    public CyberarkSecretResolver(SecretProviderLoaderProperties loaderProperties) {
        this.cyberarkJarLoader = new SecretProviderJarLoader(loaderProperties, cyberarkClassProbe, cyberarkName, cyberarkJarName);
        if (!this.cyberarkJarLoader.hasErrors(false)) {
            this.cyberarkSecretResolverExecutor = new CyberarkSecretResolverExecutor();
        }
    }

    protected String execute(Map<String, String> secretResolverRequest) {
        if (!this.cyberarkJarLoader.hasErrors(true)) {
            return this.cyberarkSecretResolverExecutor.execute(secretResolverRequest);
        }
        throw new SecretProviderJarFileNotFound(String.format("Agent not fully configured for automations with %s secret provider. See agent logs for more details.", cyberarkName));
    }

    public boolean isFullyConfigured() {
        return !this.cyberarkJarLoader.hasErrors(false);
    }
}

