/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.cyberark.service;

import cloud.celonis.cyberark.exception.CredentialsResolveException;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javapasswordsdk.PSDKPassword;
import javapasswordsdk.PSDKPasswordRequest;
import javapasswordsdk.PasswordSDK;
import javapasswordsdk.exceptions.PSDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CyberarkSecretResolverExecutor {
    private static final Logger log = LoggerFactory.getLogger(CyberarkSecretResolverExecutor.class);
    @VisibleForTesting
    protected Map<String, Method> passwordRequestStringSetters;
    private static final String SETTER_PREFIX = "set";
    private String[] sensitiveProperties = new String[]{"Object", "Safe", "Folder"};

    public CyberarkSecretResolverExecutor() {
        this.passwordRequestStringSetters = Stream.of(PSDKPasswordRequest.class.getMethods()).filter(CyberarkSecretResolverExecutor::isStringSetter).collect(Collectors.toMap(CyberarkSecretResolverExecutor::extractArgumentNameFromMethod, m -> m));
    }

    protected String execute(Map<String, String> cyberarkProperties) {
        String cyberarkPropertiesToString = cyberarkProperties.toString();
        try {
            PSDKPasswordRequest passRequest = new PSDKPasswordRequest();
            PSDKPassword password = null;
            cyberarkProperties.forEach((propertyName, value) -> this.applySettersToRequest(passRequest, (String)propertyName, (String)value));
            passRequest.setFailRequestOnPasswordChange(false);
            log.info("Retrieving cyberark-sdk value");
            boolean passRetrieved = false;
            int retryIntervals = 3000;
            while (!passRetrieved) {
                password = PasswordSDK.getPassword((PSDKPasswordRequest)passRequest);
                if (password.getAttribute("PasswordChangeInProcess").equals("true")) {
                    try {
                        Thread.sleep(retryIntervals);
                        continue;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        CredentialsResolveException credentialsResolveException = new CredentialsResolveException(String.format("Thread was interrupted while retrieving password from Cyberark.\nReason: %s", this.hideSensitiveCredentials(e.getMessage())));
                        log.error(credentialsResolveException.getMessage());
                        log.debug("Cyberark properties: \"{}\".", (Object)cyberarkPropertiesToString);
                        throw credentialsResolveException;
                    }
                }
                passRetrieved = true;
            }
            log.debug("Successfully retrieved Cyberark-sdk value \"{}\"", (Object)cyberarkPropertiesToString);
            return password.getContent();
        }
        catch (PSDKException ex) {
            CredentialsResolveException credentialsResolveException = new CredentialsResolveException(String.format("Can't retrieve password from Cyberark.\nReason: %s", this.hideSensitiveCredentials(ex.getMessage())));
            log.error(credentialsResolveException.getMessage());
            log.debug("Cyberark properties: \"{}\".", (Object)cyberarkPropertiesToString);
            throw credentialsResolveException;
        }
    }

    @VisibleForTesting
    protected static boolean isStringSetter(Method method) {
        return Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && method.getName().startsWith(SETTER_PREFIX) && method.getName().length() > SETTER_PREFIX.length() && Void.TYPE.equals(method.getReturnType()) && method.getParameterCount() == 1;
    }

    @VisibleForTesting
    protected static String extractArgumentNameFromMethod(Method method) {
        return method.getName().substring(SETTER_PREFIX.length()).toLowerCase();
    }

    @VisibleForTesting
    protected void applySettersToRequest(PSDKPasswordRequest passwordRequest, String propertyName, String propertyValue) {
        String methodNameLower = propertyName.toLowerCase();
        Method method = this.passwordRequestStringSetters.get(methodNameLower);
        if (method == null) {
            log.error("Can't set resolved arguments from Cyberark property \"{}\": setter for property \"{}\" not found", (Object)propertyName, (Object)methodNameLower);
            throw new CredentialsResolveException(String.format("Can't set resolved arguments from Cyberark property \"%s\": setter for property \"%s\" not found", propertyName, methodNameLower));
        }
        try {
            method.invoke((Object)passwordRequest, propertyValue);
        }
        catch (Exception e) {
            log.error("Can't set resolved arguments from Cyberark property \"{}\": setter [{}] can't be invoked.\n Reason: {}", new Object[]{propertyName, method, e.getMessage()});
            throw new CredentialsResolveException(String.format("Can't set resolved arguments from Cyberark property \"%s\": setter [%s] can't be invoked.\n Reason: %s", propertyName, method, e.getMessage()), e);
        }
    }

    private String hideSensitiveCredentials(String message) {
        for (int i = 0; i < this.sensitiveProperties.length; ++i) {
            message = message.replaceAll(this.sensitiveProperties[i] + "=([^;\\]])*", this.sensitiveProperties[i] + "=*");
        }
        return message;
    }
}

