/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.http.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="connectors.http")
@ConditionalOnProperty(prefix="connectors.http", name={"enabled"}, havingValue="true")
public class HttpDomainWhitelistingConfig {
    private static final Logger log = LoggerFactory.getLogger(HttpDomainWhitelistingConfig.class);
    @Value(value="${whitelisted-domains:}")
    private List<String> whitelistedDomains = new ArrayList<String>();
    private boolean invalidDomains;

    public boolean hasInvalidDomains() {
        return this.invalidDomains;
    }

    public List<String> getWhitelistedDomains() {
        if (this.whitelistedDomains == null) {
            this.whitelistedDomains = new ArrayList<String>();
        }
        return this.whitelistedDomains;
    }

    public void setWhitelistedDomains(List<String> whitelistedDomains) {
        if (whitelistedDomains == null) {
            return;
        }
        whitelistedDomains.forEach(domain -> {
            try {
                this.whitelistedDomains.add(new URL((String)domain).getHost());
            }
            catch (MalformedURLException e) {
                log.error(String.format("%s : has incorrect format: %s", domain, e.getMessage()));
                log.debug("Error details: ", (Throwable)e);
                this.invalidDomains = true;
            }
        });
    }
}

