/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.http.model;

import cloud.celonis.http.validation.URLConstraint;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;

@JsonIgnoreProperties(ignoreUnknown=true)
public class HttpRequest {
    @NotEmpty
    @URLConstraint
    private String url;
    @NotNull
    private HttpMethod method;
    private HttpHeaders headers;
    private Object body;
    private LinkedMultiValueMap<String, String> queryParams;

    public LinkedMultiValueMap<String, String> getQueryParams() {
        if (this.queryParams == null) {
            this.queryParams = new LinkedMultiValueMap();
        }
        return this.queryParams;
    }

    public String getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public Object getBody() {
        return this.body;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public void setQueryParams(LinkedMultiValueMap<String, String> queryParams) {
        this.queryParams = queryParams;
    }
}

