/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.http.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.http.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service(value="http")
@ConditionalOnProperty(prefix="connectors.http", name={"enabled"}, havingValue="true")
public class HttpConnector
extends ConnectorBase<HttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HttpConnector.class);
    private final RestTemplate restTemplate;

    public HttpConnector(@Qualifier(value="internalHttpRestTemplate") RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public ResponseEntity<?> execute(HttpRequest httpRequest) {
        try {
            HttpEntity httpEntity = new HttpEntity(httpRequest.getBody(), (MultiValueMap)httpRequest.getHeaders());
            return this.restTemplate.exchange(UriComponentsBuilder.fromHttpUrl((String)httpRequest.getUrl()).encode().queryParams(httpRequest.getQueryParams()).build().toUri(), httpRequest.getMethod(), httpEntity, String.class);
        }
        catch (RestClientResponseException e) {
            return new ResponseEntity((Object)e.getResponseBodyAsString(), (MultiValueMap)e.getResponseHeaders(), HttpStatus.valueOf((int)e.getRawStatusCode()));
        }
        catch (Exception e) {
            log.error("Something went wrong while executing HTTP Connector, message={}", (Object)e.getMessage());
            log.debug("Exception details", (Throwable)e);
            return new ResponseEntity((Object)e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
        }
    }
}

