/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.http.validation;

import cloud.celonis.commons.utils.UrlUtils;
import cloud.celonis.http.model.HttpDomainWhitelistingConfig;
import cloud.celonis.http.validation.URLConstraint;
import java.net.URL;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLValidator
implements ConstraintValidator<URLConstraint, String> {
    private static final Logger log = LoggerFactory.getLogger(URLValidator.class);
    private final HttpDomainWhitelistingConfig httpDomainWhitelistingConfig;

    public URLValidator(HttpDomainWhitelistingConfig httpDomainWhitelistingConfig) {
        this.httpDomainWhitelistingConfig = httpDomainWhitelistingConfig;
    }

    public boolean isValid(String url, ConstraintValidatorContext constraintValidatorContext) {
        if (!UrlUtils.isValidUrl((String)url)) {
            return false;
        }
        if (this.httpDomainWhitelistingConfig.getWhitelistedDomains().isEmpty() && !this.httpDomainWhitelistingConfig.hasInvalidDomains()) {
            return true;
        }
        if (this.httpDomainWhitelistingConfig.hasInvalidDomains()) {
            log.warn("Provided whitelisted domains on application.yml have incorrect format");
        }
        try {
            String domain = new URL(url).getHost();
            return this.httpDomainWhitelistingConfig.getWhitelistedDomains().contains(domain);
        }
        catch (Exception e) {
            log.error("URL validation failed: ", (Throwable)e);
            return false;
        }
    }
}

