/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.mapper;

import cloud.celonis.saprfc.exception.rfc.execution.InvalidPropertyKeyException;
import cloud.celonis.saprfc.exception.rfc.execution.ParameterNotFoundException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RfmParameterMapper {
    private static final Logger log = LoggerFactory.getLogger(RfmParameterMapper.class);

    private RfmParameterMapper() {
    }

    public static void mapAllParameters(Map<String, Object> inputs, JCoFunction function) throws ParameterNotFoundException, InvalidPropertyKeyException {
        if (inputs == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : inputs.entrySet()) {
            if (entry.getValue() instanceof List) {
                RfmParameterMapper.mapTableParameter(entry.getKey(), (List)entry.getValue(), function);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                RfmParameterMapper.mapStructureParameter(entry.getKey(), (Map)entry.getValue(), function);
                continue;
            }
            RfmParameterMapper.mapFieldParameter(entry.getKey(), entry.getValue(), function);
        }
    }

    public static Map<String, JCoParameterList> getParameterListMap(JCoFunction function) {
        HashMap<String, JCoParameterList> parametersMap = new HashMap<String, JCoParameterList>();
        parametersMap.put("importParameters", function.getImportParameterList());
        parametersMap.put("exportParameters", function.getExportParameterList());
        parametersMap.put("tableParameters", function.getTableParameterList());
        parametersMap.put("changingParameters", function.getChangingParameterList());
        return parametersMap;
    }

    public static Map<String, Object> asJson(Map<String, JCoParameterList> parametersMap, ObjectMapper agentObjectMapper) throws JsonProcessingException {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>();
        for (Map.Entry<String, JCoParameterList> entry : parametersMap.entrySet()) {
            if (entry.getValue() == null) continue;
            String stringifiedValue = entry.getValue().toJSON();
            try {
                jsonMap.putAll((Map)agentObjectMapper.readValue(stringifiedValue, Map.class));
            }
            catch (JsonProcessingException e) {
                log.error("Failed to parse " + entry.getKey());
                log.error("Value: {}", (Object)stringifiedValue);
                throw e;
            }
        }
        return jsonMap;
    }

    public static JCoTable getTableParameter(String tableName, JCoFunction function) {
        JCoFunctionTemplate functionTemplate = function.getFunctionTemplate();
        if (functionTemplate.getTableParameterList() != null && functionTemplate.getTableParameterList().hasField(tableName)) {
            return function.getTableParameterList().getTable(tableName);
        }
        if (functionTemplate.getImportParameterList() != null && functionTemplate.getImportParameterList().hasField(tableName) && function.getImportParameterList().getField(tableName).isTable()) {
            return function.getImportParameterList().getTable(tableName);
        }
        if (functionTemplate.getChangingParameterList() != null && functionTemplate.getChangingParameterList().hasField(tableName) && function.getChangingParameterList().getField(tableName).isTable()) {
            return function.getChangingParameterList().getTable(tableName);
        }
        return null;
    }

    public static JCoStructure getStructureParameter(String structureName, JCoFunction function) {
        JCoFunctionTemplate functionTemplate = function.getFunctionTemplate();
        if (functionTemplate.getImportParameterList() != null && functionTemplate.getImportParameterList().hasField(structureName) && function.getImportParameterList().getField(structureName).isStructure()) {
            return function.getImportParameterList().getStructure(structureName);
        }
        if (functionTemplate.getChangingParameterList() != null && functionTemplate.getChangingParameterList().hasField(structureName) && function.getChangingParameterList().getField(structureName).isStructure()) {
            return function.getChangingParameterList().getStructure(structureName);
        }
        return null;
    }

    @VisibleForTesting
    protected static void mapTableParameter(String tableName, List<?> tableElements, JCoFunction function) throws ParameterNotFoundException, InvalidPropertyKeyException {
        JCoTable table = RfmParameterMapper.getTableParameter(tableName, function);
        if (table == null) {
            throw new ParameterNotFoundException(String.format("Could not find table parameter named '%s' in '%s'", tableName, function.getName()));
        }
        RfmParameterMapper.mapTableValues(tableName, tableElements, table);
    }

    private static void mapTableValues(String tableName, List<?> tableElements, JCoTable table) throws InvalidPropertyKeyException, ParameterNotFoundException {
        table.appendRows(tableElements.size());
        for (int i = 0; i < tableElements.size(); ++i) {
            if (tableElements.get(i) instanceof Map) {
                table.setRow(i);
                Map struct = (Map)tableElements.get(i);
                RfmParameterMapper.mapRecordValues((JCoRecord)table, struct, tableName);
                continue;
            }
            table.setRow(i);
            table.setValue(0, tableElements.get(i));
        }
    }

    @VisibleForTesting
    protected static void mapStructureParameter(String structureName, Map<?, ?> structureInputs, JCoFunction function) throws ParameterNotFoundException, InvalidPropertyKeyException {
        JCoStructure structure = RfmParameterMapper.getStructureParameter(structureName, function);
        if (structure == null) {
            throw new ParameterNotFoundException(String.format("Could not find import parameter named '%s' in '%s'", structureName, function.getName()));
        }
        RfmParameterMapper.mapRecordValues((JCoRecord)structure, structureInputs, structureName);
    }

    @VisibleForTesting
    protected static void mapRecordValues(JCoRecord record, Map<?, ?> structure, String recordName) throws InvalidPropertyKeyException, ParameterNotFoundException {
        for (Map.Entry<?, ?> structureEntry : structure.entrySet()) {
            if (structureEntry.getKey() instanceof String) {
                if (structureEntry.getValue() instanceof List) {
                    RfmParameterMapper.mapTableParameter((String)structureEntry.getKey(), (List)structureEntry.getValue(), record, recordName);
                    continue;
                }
                if (structureEntry.getValue() instanceof Map) {
                    RfmParameterMapper.mapStructureParameter((String)structureEntry.getKey(), (Map)structureEntry.getValue(), record, recordName);
                    continue;
                }
                RfmParameterMapper.mapFieldParameter((String)structureEntry.getKey(), structureEntry.getValue(), record, recordName);
                continue;
            }
            throw new InvalidPropertyKeyException("Invalid property key, expected String key, got: " + structureEntry.getKey());
        }
    }

    @VisibleForTesting
    protected static void mapTableParameter(String tableName, List<?> tableElements, JCoRecord record, String recordName) throws ParameterNotFoundException, InvalidPropertyKeyException {
        JCoTable table = RfmParameterMapper.getTableParameter(tableName, record);
        if (table == null) {
            throw new ParameterNotFoundException(String.format("Could not find table parameter named '%s' in '%s'", tableName, recordName));
        }
        RfmParameterMapper.mapTableValues(tableName, tableElements, table);
    }

    @VisibleForTesting
    protected static JCoTable getTableParameter(String structureName, JCoRecord record) {
        if (record.getField(structureName) != null && record.getField(structureName).isTable()) {
            return record.getTable(structureName);
        }
        return null;
    }

    @VisibleForTesting
    protected static void mapStructureParameter(String structureName, Map<?, ?> structureInputs, JCoRecord record, String recordName) throws ParameterNotFoundException, InvalidPropertyKeyException {
        JCoStructure structure = RfmParameterMapper.getStructureParameter(structureName, record);
        if (structure == null) {
            throw new ParameterNotFoundException(String.format("Could not find structure parameter named '%s' in '%s'", structureName, recordName));
        }
        RfmParameterMapper.mapRecordValues((JCoRecord)structure, structureInputs, structureName);
    }

    @VisibleForTesting
    protected static JCoStructure getStructureParameter(String structureName, JCoRecord record) {
        if (record.getField(structureName) != null && record.getField(structureName).isStructure()) {
            return record.getStructure(structureName);
        }
        return null;
    }

    @VisibleForTesting
    protected static void mapFieldParameter(String fieldName, Object fieldValue, JCoRecord record, String recordName) throws ParameterNotFoundException {
        JCoField field = RfmParameterMapper.getFieldParameter(fieldName, record);
        if (field == null) {
            throw new ParameterNotFoundException(String.format("Could not find field parameter named '%s' in '%s'", fieldName, recordName));
        }
        field.setValue(fieldValue);
    }

    @VisibleForTesting
    protected static JCoField getFieldParameter(String fieldName, JCoRecord record) {
        if (record.getField(fieldName) != null && !record.getField(fieldName).isStructure() && !record.getField(fieldName).isTable()) {
            return record.getField(fieldName);
        }
        return null;
    }

    @VisibleForTesting
    protected static void mapFieldParameter(String fieldName, Object fieldValue, JCoFunction function) throws ParameterNotFoundException {
        JCoField field = RfmParameterMapper.getFieldParameter(fieldName, function);
        if (field == null) {
            throw new ParameterNotFoundException(String.format("Could not find import parameter named '%s' in '%s'", fieldName, function.getName()));
        }
        field.setValue(fieldValue);
    }

    @VisibleForTesting
    protected static JCoField getFieldParameter(String fieldName, JCoFunction function) {
        JCoFunctionTemplate functionTemplate = function.getFunctionTemplate();
        if (functionTemplate.getImportParameterList() != null && functionTemplate.getImportParameterList().hasField(fieldName) && !function.getImportParameterList().getField(fieldName).isStructure() && !function.getImportParameterList().getField(fieldName).isTable()) {
            return function.getImportParameterList().getField(fieldName);
        }
        if (functionTemplate.getChangingParameterList() != null && functionTemplate.getChangingParameterList().hasField(fieldName) && !function.getChangingParameterList().getField(fieldName).isTable() && !function.getChangingParameterList().getField(fieldName).isStructure()) {
            return function.getChangingParameterList().getField(fieldName);
        }
        return null;
    }
}

