/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.service;

import cloud.celonis.saprfc.domain.SapRfcRequest;
import cloud.celonis.saprfc.domain.error.RfcExecutionErrorResponse;
import cloud.celonis.saprfc.model.ExtendedStructureMetadata;
import cloud.celonis.saprfc.model.ParameterMetadata;
import cloud.celonis.saprfc.model.RfmMetadata;
import cloud.celonis.saprfc.model.rfc.execution.error.RfcExecutionErrorKey;
import com.google.common.annotations.VisibleForTesting;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.DefaultListMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RfmMetadataService {
    private static final Logger log = LoggerFactory.getLogger(RfmMetadataService.class);
    @VisibleForTesting
    static final String FUNCTION_NAMES = "FUNCTIONNAMES";
    @VisibleForTesting
    static final String PURGE_ALL_CACHE = "/AGENT/PURGE_ALL_CACHE";

    private RfmMetadataService() {
    }

    public static Object handleMetadataRequest(SapRfcRequest request, JCoRepository repository) throws JCoException {
        String rfmName = null;
        if (request.isMetadataRequest()) {
            rfmName = request.getRfmName();
        } else if (request.getRfmParams() != null && request.getRfmParams().get(FUNCTION_NAMES) instanceof List && ((List)request.getRfmParams().get(FUNCTION_NAMES)).get(0) instanceof String) {
            rfmName = (String)((List)request.getRfmParams().get(FUNCTION_NAMES)).get(0);
        }
        if (rfmName == null) {
            String errorMessage = "Failed to generate metadata. Function name is missing";
            log.error(errorMessage);
            return new RfcExecutionErrorResponse(RfcExecutionErrorKey.RFM_NOT_FOUND.name(), errorMessage);
        }
        if (Arrays.asList(repository.getCachedFunctionTemplateNames()).contains(rfmName)) {
            log.debug("Returning cached metadata for function '{}'", (Object)rfmName);
        } else {
            log.debug("Generating metadata for function '{}'", (Object)rfmName);
        }
        JCoFunctionTemplate functionTemplate = repository.getFunctionTemplate(rfmName);
        if (functionTemplate == null) {
            String errorMessage = String.format("Could not find RFM named '%s'", rfmName);
            log.error("Failed to generate metadata. " + errorMessage);
            return new RfcExecutionErrorResponse(RfcExecutionErrorKey.RFM_NOT_FOUND.name(), errorMessage);
        }
        return RfmMetadataService.extractMetadata(functionTemplate, repository);
    }

    public static List<String> invalidateCache(String rfmName, JCoRepository repository) {
        if (rfmName.equals(PURGE_ALL_CACHE)) {
            Object[] cachedFunctions = repository.getCachedFunctionTemplateNames();
            String[] cachedStructures = repository.getCachedRecordMetaDataNames();
            repository.clear();
            log.info(String.format("Cleared all cached metadata, total of {} function%s and {} structure%s", cachedFunctions.length != 1 ? "s" : "", cachedStructures.length != 1 ? "s" : ""), (Object)cachedFunctions.length, (Object)cachedStructures.length);
            log.debug("Cleared cached metadata of functions: {}", (Object)Arrays.toString(cachedFunctions));
            return Arrays.asList(cachedFunctions);
        }
        if (Arrays.asList(repository.getCachedFunctionTemplateNames()).contains(rfmName)) {
            repository.removeFunctionTemplateFromCache(rfmName);
            log.info("Cleared cached metadata of function named '{}'", (Object)rfmName);
            return Collections.singletonList(rfmName);
        }
        log.info("No cached metadata found for function named '{}'", (Object)rfmName);
        return Collections.emptyList();
    }

    private static RfmMetadata extractMetadata(JCoFunctionTemplate functionTemplate, JCoRepository repository) throws JCoException {
        RfmMetadata metadata = new RfmMetadata();
        metadata.setRfmName(functionTemplate.getName());
        metadata.setParameters(new ArrayList<ParameterMetadata>());
        HashMap<String, List<ExtendedStructureMetadata>> extendedMetadataMap = new HashMap<String, List<ExtendedStructureMetadata>>();
        DefaultListMetaData exportParameters = (DefaultListMetaData)functionTemplate.getExportParameterList();
        DefaultListMetaData importParameters = (DefaultListMetaData)functionTemplate.getImportParameterList();
        DefaultListMetaData tableParameters = (DefaultListMetaData)functionTemplate.getTableParameterList();
        DefaultListMetaData changingParameters = (DefaultListMetaData)functionTemplate.getChangingParameterList();
        if (exportParameters != null) {
            RfmMetadataService.buildMetadata(repository, metadata, exportParameters, "E", extendedMetadataMap);
        }
        if (importParameters != null) {
            RfmMetadataService.buildMetadata(repository, metadata, importParameters, "I", extendedMetadataMap);
        }
        if (tableParameters != null) {
            RfmMetadataService.buildMetadata(repository, metadata, tableParameters, "T", extendedMetadataMap);
        }
        if (changingParameters != null) {
            RfmMetadataService.buildMetadata(repository, metadata, changingParameters, "C", extendedMetadataMap);
        }
        metadata.setExtendedMetadata(extendedMetadataMap.values().stream().flatMap(Collection::parallelStream).collect(Collectors.toList()));
        return metadata;
    }

    private static void buildMetadata(JCoRepository repository, RfmMetadata metadata, DefaultListMetaData listMetaData, String paramClass, Map<String, List<ExtendedStructureMetadata>> extendedMetadataMap) throws JCoException {
        for (int i = 0; i < listMetaData.getFieldCount(); ++i) {
            ParameterMetadata rfmParameter = new ParameterMetadata();
            rfmParameter.setFunctionName(metadata.getRfmName());
            rfmParameter.setName(listMetaData.getName(i));
            rfmParameter.setParameterClass(paramClass);
            rfmParameter.setTypeName(listMetaData.getRecordTypeName(i));
            rfmParameter.setFieldName(listMetaData.getRecordFieldName(i));
            rfmParameter.setAbapType(listMetaData.getAbapType(i));
            rfmParameter.setPosition(i);
            rfmParameter.setOffset(listMetaData.getJavaBufferOffset(i));
            rfmParameter.setUnicodeLength(listMetaData.getUnicodeByteLength(i));
            rfmParameter.setFractionalNumbersLength(listMetaData.getDecimals(i));
            rfmParameter.setDefaultValue(listMetaData.getDefault(i));
            rfmParameter.setDescription(listMetaData.getDescription(i));
            rfmParameter.setOptional(listMetaData.isOptional(i) ? "X" : "");
            metadata.getParameters().add(rfmParameter);
            if (!listMetaData.isStructure(i) && !listMetaData.isTable(i) || extendedMetadataMap.containsKey(rfmParameter.getTypeName())) continue;
            RfmMetadataService.buildParameterFieldMetadata(repository, extendedMetadataMap, repository.getRecordMetaData(rfmParameter.getTypeName()));
        }
    }

    private static void buildParameterFieldMetadata(JCoRepository repository, Map<String, List<ExtendedStructureMetadata>> extendedMetadataMap, JCoRecordMetaData recordMetaData) throws JCoException {
        ArrayList<ExtendedStructureMetadata> extendedStructureMetadataList = new ArrayList<ExtendedStructureMetadata>();
        extendedMetadataMap.put(recordMetaData.getName(), extendedStructureMetadataList);
        for (int j = 0; j < recordMetaData.getFieldCount(); ++j) {
            ExtendedStructureMetadata parameterField = new ExtendedStructureMetadata();
            parameterField.setParameterName(recordMetaData.getName());
            parameterField.setName(recordMetaData.getName(j));
            parameterField.setType(recordMetaData.getRecordTypeName(j));
            parameterField.setDataType(recordMetaData.getTypeAsString(j));
            parameterField.setTableLength(recordMetaData.getRecordLength());
            parameterField.setUnicodeTableLength(recordMetaData.getUnicodeRecordLength());
            parameterField.setDescription(recordMetaData.getDescription(j));
            parameterField.setFractionalNumbersLength(recordMetaData.getDecimals(j));
            parameterField.setAbapType(AbstractMetaData.getJCOTypeChar((int)recordMetaData.getType(j)));
            parameterField.setOffset(recordMetaData.getByteOffset(j));
            parameterField.setUnicodeOffset(recordMetaData.getUnicodeByteOffset(j));
            parameterField.setLength(recordMetaData.getLength(j));
            parameterField.setUnicodeLength(recordMetaData.getUnicodeByteLength(j));
            extendedStructureMetadataList.add(parameterField);
            if (!recordMetaData.isStructure(j) && !recordMetaData.isTable(j) || extendedMetadataMap.containsKey(recordMetaData.getRecordTypeName(j))) continue;
            RfmMetadataService.buildParameterFieldMetadata(repository, extendedMetadataMap, repository.getRecordMetaData(recordMetaData.getRecordTypeName(j)));
        }
    }
}

