/*
 * Decompiled with CFR 0.152.
 */
package cloud.celonis.saprfc.service;

import cloud.celonis.agent.common.connector.ConnectorBase;
import cloud.celonis.agent.common.loader.AgentLoaderProperties;
import cloud.celonis.saprfc.domain.SapRfcRequest;
import cloud.celonis.saprfc.domain.error.RfcExecutionErrorResponse;
import cloud.celonis.saprfc.model.rfc.execution.error.RfcExecutionErrorKey;
import cloud.celonis.saprfc.service.SapRfcExecutionService;
import cloud.celonis.saprfc.system.JCoLoader;
import cloud.celonis.saprfc.system.JCoNativeLibraryLoader;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service(value="sap-rfc")
@ConditionalOnProperty(prefix="connectors.sap-rfc", name={"enabled"}, havingValue="true")
public class SapRfcConnector
extends ConnectorBase<SapRfcRequest> {
    private static final Logger log = LoggerFactory.getLogger(SapRfcConnector.class);
    @VisibleForTesting
    protected JCoLoader jCoLoader;
    @VisibleForTesting
    protected SapRfcExecutionService executionService;

    public SapRfcConnector(AgentLoaderProperties loaderProperties, JCoNativeLibraryLoader jCoNativeLibraryLoader, ObjectMapper agentObjectMapper) {
        this.jCoLoader = new JCoLoader(loaderProperties, jCoNativeLibraryLoader);
        if (!this.jCoLoader.hasErrors(false)) {
            this.executionService = new SapRfcExecutionService(this.jCoLoader, agentObjectMapper);
        }
    }

    protected Object execute(SapRfcRequest request) {
        if (!this.jCoLoader.hasErrors(true)) {
            try {
                return this.executionService.execute(request);
            }
            catch (Exception unexpectedException) {
                log.error("Something went wrong executing task. {}", (Object)unexpectedException.getMessage());
                log.debug("Exception details", (Throwable)unexpectedException);
                return new RfcExecutionErrorResponse(RfcExecutionErrorKey.UNKNOWN.name(), unexpectedException.getMessage());
            }
        }
        return new RfcExecutionErrorResponse(RfcExecutionErrorKey.JCO_NOT_LOADED.name(), "Agent not fully configured for SAP automations.", "See agent logs for more details.");
    }
}

